function DF = hill2d_DF(t,Z,k)
% function HILL2D_DF
%
% Jacobian of HILL2D_F
% 
% input
%     t       time 
%     Z       1xn vector containing the points at which to evaluate the 
%             hill kinetics
%     k       1x2 vector containing the parameters K and c
% 
% output
%     DF      2x2xn matrix containing the Jacobians of the RHS evaluated at
%             each point in Z

% number of points
n = size(Z,2);

% space variables x and V
x = Z(1,:);
V = Z(2,:);

% parameters
K = k(1); c = k(2);

DF = zeros(2,2,n);
DF(1,1,:)   = -V .* c .* x.^(c-1) * K^c ./ (K^c + x.^c).^2;
DF(1,2,:) = -x.^c ./(K^c + x.^c);
DF(2,1,:) = zeros(1,n);
DF(2,2,:) = zeros(1,n);