function DF = hill1d_DF(t,Z,k)
% function HILL1D_DF
%
% derivative of hill kinetics in 1 dimension wrt Z
% 
% input
%     t       time 
%     Z       1xn vector containing the points at which to evaluate the 
%             hill kinetics
%     k       1x3 vector containing the parameters V, K and c
% 
% output
%     DF      1x1xn matrix containing the derivatives of the hill kinetics 
%             evaluated at Z

% number of points
n = size(Z,2);

% parameters
V = k(1); K = k(2); c = k(3);

DF          = zeros(1,1,n); 
DF(1,1,:)   = V * c * Z.^(c-1) * K^c ./ (K^c + Z.^c).^2;