function out = scalarProd(x,A,y)

% efficient computation of the scalar product x'*A*y in the case
% of vectorized inputs x and y

[n,m] = size(x);
if [size(x)~=size(y)]|[size(A,1)~=size(A,2)]|[size(A,1)~=size(x,1)]
    error(' dimension mismatch! ');
end;

Ax = A*y;
out = sum(reshape(x(:).*Ax(:),n,m),1);
