function A = adjacencyMatrix(basis, pts, D, h, delta)
% function ADJACENCYMATRIX
% find points that have to be considered for evaluation of each basis
% function
%
% the output matrix A contains in every row i 0 or 1 for each point from
% pts adjacent to the center of the ith basis element
%
% input
%     basis   struct containing the parameters of the basis function
%     pts     matrix containing the pts that are or not in the vicinity of 
%             the basis functions (pts will typically be basis.mu)
%     D       scaling parameter of the basis functions
%     h       grid size 
%     delta   scalar (safety factor)
% 
% output
%     A       matrix containing in every row i 0 or 1 for each point from
%             pts adjacent to the center of the ith basis element
%
% written by
%   Andrea Y. Weisse
%   Centre for Systems Biology at Edinburgh
%   University of Edinburgh
%
%   email: andrea.weisse@ed.ac.uk
%
% Copyright (C) 2011, University of Edinburgh
%
% FOR ACADEMIC USE this program is free software; you can redistribute 
% it and/or modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version. 
% See http://www.gnu.org/licenses/gpl.html for details.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details. 
% 

n = basis.no;
m = size(pts,2);
A = zeros(n,m);
dim = size(pts,1);

if (length(h) == 1) && (length(D) == 1)
    for i = 1:n
        x       = basis.mu(:,i);
        % compute distance (in inf-norm) of all pts to x
        diffx   = x * ones(1,m) - pts;
        A(i,:)  = sum(abs(diffx) <= h*sqrt(-D * log(delta)),1);
        A(i,:)  = A(i,:) ==dim;
    end
else    % if (length(h) > 1) || (length(D) > 1)
    for i = 1:n
        x       = basis.mu(:,i);
        % compute distance (in inf-norm) of all pts to x
        diffx   = x * ones(1,m) - pts;
        A(i,:)  = sum(abs(diffx) <= ((h' .* sqrt(-D * log(delta))) * ones(1,m)),1);
        A(i,:)  = A(i,:) == dim;
    end
end
A = logical(A);