function trace = hill2d_traceDF(t,Z,k)
% function HILL2D_traceDF
%
% trace of Jacobian of HILL2D_F
% 
% input
%     t       time 
%     Z       1xn vector containing the points at which to evaluate the 
%             hill kinetics
%     k       1x2 vector containing the parameters K and c
% 
% output
%     trace   2xn vector containing the traces of the Jacobians of the RHS 
%             evaluated at each point in Z

% number of points
n = size(Z,2);

% space variables x and V
x = Z(1,:);
V = Z(2,:);

% parameters
K = k(1); c = k(2);

trace  = -V .* c .* x.^(c-1) * K^c ./ (K^c + x.^c).^2;