%%% Version: April 24th, 2017
%%%
%%% This function assigns the colors to the given Species to 
%%% facilitate plotting and to have always the same color for the specific 
%%% species.
%%%
%%% 
%%% Author: Jane Knoechel 
%%%
function ColorStates = Wajima_bloodCoagulation_specifyColorStates(States)

Color=[colormap('jet');colormap('HSV');colormap('Lines');colormap('jet');colormap('HSV');colormap('Lines');colormap('jet');colormap('HSV');colormap('Lines')];
S=struct('XII',Color(1+(1-1)*7,:),'XIIa',Color(2+(2-1)*7,:),'VIII',Color(3+(3-1)*7,:),...
    'VIIIa',[0.301960796117783 0.745098054409027 0.933333337306976],'IX',Color(5+(5-1)*7,:),'IXa',Color(6+(6-1)*7,:),   ...
    'XI',Color(7+(7-1)*7,:),'XIa',Color(8+(8-1)*7,:),'VII',[0.6 0 0.2],...
    'VIIa',Color(10+(10-1)*7,:),'X',Color(11+(11-1)*7,:),'Xa',[0 0.498039215803146 0], ...
    'V', [0.678431391716003 0.921568632125854 1], 'Va',Color(14+(14-1)*7,:),'Xa_Va',Color(15+(15-1)*7,:),...
    'II',Color(16+(16-1)*7,:),'IIa',Color(17+(17-1)*7,:),'TAT',Color(18+(18-1)*7,:), ...
    'Fg',Color(19+(19-1)*7,:),'F',Color(20+(20-1)*7,:),'XF',Color(21+(21-1)*7,:),...
    'FDP',Color(22+(22-1)*7,:),'D',Color(23+(23-1)*7,:),'XIII',Color(24+(24-1)*7,:), ...
    'XIIIa',Color(25+(25-1)*7,:),'Pg',Color(26+(26-1)*7,:),'P',Color(27+(27-1)*7,:),...
    'PC',Color(28+(28-1)*7,:),'APC',[0.466666668653488 0.674509823322296 0.18823529779911],'Tmod',Color(30+(30-1)*7,:), ...
    'IIa_Tmod',Color(31+(31-1)*7,:),'IXa_VIIIa',Color(32+(32-1)*7,:),'TF',Color(33+(33-1)*7,:),...
    'VII_TF',Color(34+(34-1)*7,:),'VIIa_TF',[0.600000023841858 0.600000023841858 0],'TFPI',Color(36+(36-1)*7,:), ...
    'Xa_TFPI',Color(37+(37-1)*7,:),'VIIa_TF_Xa_TFPI',Color(38+(38-1)*7,:),...
    'PS',Color(39+(39-1)*7,:),'APC_PS',Color(40+(40-1)*7,:),'Pk',Color(41+(41-1)*7,:),...
    'K',Color(42+(42-1)*7,:),'VK',Color(43+(43-1)*7,:),'VKH2',Color(44+(44-1)*7,:),...
    'VKO',Color(45+(45-1)*7,:),'VK_p',Color(46+(46-1)*7,:),'Awarf',Color(47+(47-1)*7,:),...
    'Cwarf',Color(48+(48-1)*7,:),'CA',Color(49+(49-1)*7,:),'AEnox',Color(50+(50-1)*7,:),...
    'AT_III_Heparin',Color(51+(51-1)*7,:),'ENO_p',Color(52+(52-1)*7,:),'AUC',Color(53+(53-1)*7,:),...
    'AVenom',[1 0.843137254901961 0],'CVenom',Color(55+(55-1)*7,:),'TaipanVenom',Color(56+(56-1)*7,:),'ATIII',Color(57+(57-1)*7,:),...
    'delayTaipan1',Color(58+(58-1)*7,:),'delayTaipan2',Color(59+(59-1)*7,:),'AVenom_Tiger',Color(60+(60-1)*7,:),...
    'CVenom_Tiger',Color(61+(61-1)*7,:),'AT_III_UFH',Color(62+(62-1)*7,:));
ColorStates=[];
for i=1:length(States)
    ColorStates.(States{i})=S.(States{i});
end
end