%%% Version: February 31st, 2014
%%% 
%%% This function increases thickness of lines in graphical output
%%% 
%%% For references and citation, please see MAIN script.
%%% 
%%% Copyright (C) 2014, Universitaet Potsdam, Germany
%%% Contact: W. Huisinga, huisinga@uni-potsdam.de
%%%
%%% The program is distributed under the terms of the 
%%% Creative Commons License (CC BY-NC-SA 3.0):
%%% Attribution-NonCommercial-ShareAlike 3.0 Unported 
%%%
%%% For a SHORT HUMAN-READABLE SUMMARY OF THE LEGAL CODE, see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/
%%%
%%% For the Legal Code (the full license) see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/legalcode
%%%
%%%
function [] = fett(figNr)

% Increases line width, font size, etc.
% Call by, e.g., fett(2)

figure(figNr);

lw = 2;   %line width
fs = 20;  %fontsize

h = findobj(gca,'Type','line');
set(h,'LineWidth',lw);

set(gca,'FontSize',fs);
set(gca,'LineWidth',lw);
set(get(gca,'title'),'Fontsize',fs);
set(get(gca,'xlabel'),'Fontsize',fs);
set(get(gca,'ylabel'),'Fontsize',fs);
set(legend,'Fontsize',fs); 