library(icbn)
source("cbn_models.R")




#################################### Fit the CBN models for the reverse transcriptase inhibitor zidovudine (ZDV)  #############################################
set.seed(100)
# The function generate_input_files_for_ode_model generates all the necessary input files for the ODE model. Arguments for this function are as follow:
# X: observed genotypes
# Y: Associated resistance factors
# mutation_names: the names of mutations 
# ctcbn_folder: installation path for CT-CBN package
# a temporary folder needed by the CT-CBN package. It can be the current directory.

# The following R data file contains genotypes, X, and their associated resistance factors, Y for the drug ZDV.
load("zdv.Rdata")
mutation_names = colnames(X)
ctcbn_folder="/home/hesamm/Documents/ct_cbn/"
temp_path = "./"	

zdv_fit = generate_input_files_for_ode_model(X, Y, mutation_names, ctcbn_folder, temp_path)
save_cbn_model(zdv_fit,  "ZDV", "ZDV_OUTPUTS/")

#zdv_demo_fit = generate_input_files_for_ode_model(X, Y, mutation_names, ctcbn_folder, temp_path, nIter=1, maxIter=2)  
#save_cbn_model(zdv_demo_fit,  "ZDV", "ZDV_DEMO_OUTPUTS/")

#################################### Fit the CBN models for the protease inhibitor indinavir (IDV) #############################################
set.seed(200)
#The following data file contains genotypes, X, and their associated resistance factors, Y for the drug IDV.
load("idv.Rdata")
mutation_names = colnames(X)
idv_fit = generate_input_files_for_ode_model(X, Y, mutation_names, ctcbn_folder, temp_path)
save_cbn_model(idv_fit,  "IDV", "IDV_OUTPUTS/")

#idv_demo_fit = generate_input_files_for_ode_model(X, Y, mutation_names, ctcbn_folder, temp_path, nIter=1, maxIter=2)
#save_cbn_model(idv_demo_fit,  "IDV", "IDV_DEMO_OUTPUTS/")


# The following ICBN parameters can be given additionally to the function generate_input_files_for_ode_model. In the manuscript, the default values have been used.
# epsGuess:  allowed violations for an edge to be included
# epsStop: stop EM if likelihood difference below epsStop
# nIter: Number of iterations in the annealing run
# tInit: Initial temperature in the annealing run
# tAlpha: Temperature for preselecting propositions in the annealing run
# tFactor: cooling factor in the annealing run
# maxIter: Maximal number of iterations in isotone
