%%% 
%%% This function allows to compile some descriptive statistics realted to
%%% the virtual population
%%% 
%%% Version: February 10th, 2014. 
%%% For references and citation, please see MAIN script.
%%% 
%%% Copyright (C) 2014, Universitaet Potsdam, Germany
%%% Contact: W. Huisinga, huisinga@uni-potsdam.de
%%%
%%% The program is distributed under the terms of the 
%%% Creative Commons License (CC BY-NC-SA 3.0):
%%% Attribution-NonCommercial-ShareAlike 3.0 Unported 
%%%
%%% For a SHORT HUMAN-READABLE SUMMARY OF THE LEGAL CODE, see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/
%%%
%%% For the Legal Code (the full license) see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/legalcode
%%%
%%%

function stats = GenericPBPKmodel_dataAnalysis(individual)


stats.size = length(individual); 

for id=1:stats.size 

    stats.subtype{id} = individual(id).subtype;
    stats.BH(id)      = individual(id).BH;
    stats.BW(id)      = individual(id).BW;
    stats.LBW(id)     = individual(id).LBW; 
    stats.BMI(id)     = individual(id).BMI; 
    stats.BSA(id)     = individual(id).BSA; 
    stats.hct(id)     = individual(id).hct; 
    stats.co(id)      = individual(id).co; 

end;
