%%% Version: Mar 10th, 2017
%%%
%%% This function specifies the virtual population to be studied
%%%
%%% For references and citation, please see MAIN script.
%%%
%%% Copyright (C) 2014, Universitaet Potsdam, Germany
%%% Contact: W. Huisinga, huisinga@uni-potsdam.de
%%%
%%% The program is distributed under the terms of the
%%% Creative Commons License (CC BY-NC-SA 3.0):
%%% Attribution-NonCommercial-ShareAlike 3.0 Unported
%%%
%%% For a SHORT HUMAN-READABLE SUMMARY OF THE LEGAL CODE, see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/
%%%
%%% For the Legal Code (the full license) see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/legalcode
%%%
%%%


%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% BEGIN: MAIN FUNCTION
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

function individual = GenericPBPKmodel_virtualPopulation(population,dosing,reference)


%%% To specify an individual, use the reference individuals or specify an
%%% individual based on the following characteristics:
%%%
%%% individual(id).species.type = 'human', 'rat', 'mouse'
%%% individual(id).species.sex  = 'male', 'female'
%%% individual(id).species.age  = (for human, choose age in years from 0,1,5,10,15,35=20-50, otherwise set to NaN)
%%% individual(id).species.BW   = (specify BW in [kg])
%%% individual(id).species.BH   = (for human, specify BH in [m], otherwise set to NaN)
%%%
%%% If for given species type, sex and age, the species BW and BH differ
%%% from those of the corresponding reference individual, the reference
%%% individual will be used to scale to the requested individual with
%%% stated BW and BH. The default method is 'LBW' scaling for human and
%%% 'BW' scaling for animals. Alternatives can be specified with
%%% individual(id).species.scalingMethod = 'LBW', 'BW'
%%% (see GenericPBPKmodel_scaleIndividual.m for details)

fprintf('\n   Virtual population >>%s<< \n',population.how2generate);

individual = struct('id',[],'details',[],'color',[],'species',[],'dosing',[],'drug',[],'model',[],'estimation',[],'pred',[],'stdout',[],'info',[]);


switch population.how2generate
    
    
    % ======================================================================= %
    % -- mAb -- mAb -- mAb -- mAb -- mAb -- mAb -- mAb -- mAb -- mAb -- mAb --
    % ======================================================================= %
    case 'mAb_PBPK_KDModel_2KD_factor1_mAb'
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'd';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;                        % duration of iv infusion
        single_dose.interval  = 60 ;                        % multiple dosing interval
        
        dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
        dosing.drug  = 'mAb7E3';
        dosing.dose  = 8;
        dosing.route = 'iv_bolus';
        
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
            dosing(2).time  = 0;
        end;
        
        
        
        id=0;
        %%%KD Model with 3 drugs and identical binding affinity KD 750nM,
        %%%compund =mAb
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 0;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'b';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750foralldrugs        ='yes';
        individual(id).stdout.compound               = 'mAb';
        individual(id).model.Estimation_plasmaData   ='yes';
        
        id=id+1;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 0;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_Garg2007';
        individual(id).color          = 'b';
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 1000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'k';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750foralldrugs        ='yes';
        individual(id).stdout.compound               = 'mAb';
        individual(id).model.Estimation_plasmaData   ='yes';
        
        
        id=id+1;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 1000;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_IVIG1_Garg2007';
        individual(id).color          = 'k';
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 2000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'g';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750foralldrugs        ='yes';
        individual(id).stdout.compound               = 'mAb';
        individual(id).model.Estimation_plasmaData   ='yes';
        
        
        
        id=id+1;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 2000;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_IVIG2_Garg2007';
        individual(id).color          = 'g';
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 400;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'r';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750foralldrugs     ='yes';
        individual(id).stdout.compound            = 'mAb';
        individual(id).model.Estimation_plasmaData='yes';
        
        
        id=id+1;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 400;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_IVIG04_Garg2007';
        individual(id).color          = 'r';
        
        
        % ======================================================================= %
    case 'mAb_PBPK_KDModel_2KD_factor10_mAb'
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'd';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;                        % duration of iv infusion
        single_dose.interval  = 60 ;                        % multiple dosing interval
        
        dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
        dosing.drug  = 'mAb7E3';
        dosing.dose  = 8;
        dosing.route = 'iv_bolus';
        
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
            dosing(2).time  = 0;
        end;
        
        
        
        id=0;
        %%%KD Model with 3 drugs but different binding affinity KD 750 vs 82  nM,
        %%%compund =mAb
        
        
        id=id+1;
        individual(id).species                      = reference.mouse.male_25g;
        individual(id).dosing                       = dosing;
        individual(id).dosing(1).dose               = 8;
        individual(id).dosing(2).dose               = 0;
        individual(id).model.type                   = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                        = 'b';
        individual(id).model.FcRn_status            = 'wild-type';
        individual(id).estimation.modus             = 'off';
        individual(id).estimation.expIds            = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice               = 'no';
        individual(id).model.Rat                    = 'no';
        individual(id).model.WTmice                 = 'yes';
        individual(id).model.NudeMice               = 'no';
        individual(id).model.KD750vs82              = 'yes';
        individual(id).stdout.compound              = 'mAb';
        individual(id).model.Estimation_plasmaData  = 'yes';
        
        
        id=id+1;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 0;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_Garg2007';
        individual(id).color          = 'b';
        
        id=id+1;
        individual(id).species                      = reference.mouse.male_25g;
        individual(id).dosing                       = dosing;
        individual(id).dosing(1).dose               = 8;
        individual(id).dosing(2).dose               = 1000;
        individual(id).model.type                   = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                        = 'k';
        individual(id).model.FcRn_status            = 'wild-type';
        individual(id).estimation.modus             = 'off';
        individual(id).estimation.expIds            = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice               = 'no';
        individual(id).model.Rat                    = 'no';
        individual(id).model.WTmice                 = 'yes';
        individual(id).model.NudeMice               = 'no';
        individual(id).model.KD750vs82              = 'yes';
        individual(id).stdout.compound              = 'mAb';
        individual(id).model.Estimation_plasmaData  = 'yes';
        
        
        
        
        id=id+1;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 1000;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_IVIG1_Garg2007';
        individual(id).color          = 'k';
        
        
        
        id=id+1;
        individual(id).species                      = reference.mouse.male_25g;
        individual(id).dosing                       = dosing;
        individual(id).dosing(1).dose               = 8;
        individual(id).dosing(2).dose               = 2000;
        individual(id).model.type                   = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                        = 'g';
        individual(id).model.FcRn_status            = 'wild-type';
        individual(id).estimation.modus             = 'off';
        individual(id).estimation.expIds            = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice               = 'no';
        individual(id).model.Rat                    = 'no';
        individual(id).model.WTmice                 = 'yes';
        individual(id).model.NudeMice               = 'no';
        individual(id).model.KD750vs82              = 'yes';
        individual(id).stdout.compound              = 'mAb';
        individual(id).model.Estimation_plasmaData  = 'yes';
        
        
        id=id+1;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 2000;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_IVIG2_Garg2007';
        individual(id).color          = 'g';
        
        
        
        
        
        id=id+1;
        individual(id).species                      = reference.mouse.male_25g;
        individual(id).dosing                       = dosing;
        individual(id).dosing(1).dose               = 8;
        individual(id).dosing(2).dose               = 400;
        individual(id).model.type                   = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                        = 'r';
        individual(id).model.FcRn_status            = 'wild-type';
        individual(id).estimation.modus             = 'off';
        individual(id).estimation.expIds            = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice               = 'no';
        individual(id).model.Rat                    = 'no';
        individual(id).model.WTmice                 = 'yes';
        individual(id).model.NudeMice               = 'no';
        individual(id).model.KD750vs82              = 'yes';
        individual(id).stdout.compound              = 'mAb';
        individual(id).model.Estimation_plasmaData  = 'yes';
        
        
        id=id+1;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 400;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_IVIG04_Garg2007';
        individual(id).color          = 'r';
        % ======================================================================= %
        
    case 'mAb_PBPK_KDModel_2KD_factor2_mAb'
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'd';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;                        % duration of iv infusion
        single_dose.interval  = 60 ;                        % multiple dosing interval
        
        dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
        dosing.drug  = 'mAb7E3';
        dosing.dose  = 8;
        dosing.route = 'iv_bolus';
        
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
            dosing(2).time  = 0;
        end;
        
        
        
        id=0;
        %%%KD Model with 3 drugs but different binding affinity KD 750 vs 375  nM,
        %%%compund =mAb
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 0;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'b';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     = 'yes';
        individual(id).stdout.compound      = 'mAb';
        individual(id).model.Estimation_plasmaData        ='yes';
        
        
        id=id+1;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 0;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_Garg2007';
        individual(id).color          = 'b';
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 1000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'k';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     = 'yes';
        individual(id).stdout.compound      = 'mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        id=id+1;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 1000;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_IVIG1_Garg2007';
        individual(id).color          = 'k';
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 2000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'g';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     = 'yes';
        individual(id).stdout.compound      = 'mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        id=id+1;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 2000;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_IVIG2_Garg2007';
        individual(id).color          = 'g';
        
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 400;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'r';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     = 'yes';
        individual(id).stdout.compound      = 'mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        id=id+1;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 400;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_IVIG04_Garg2007';
        individual(id).color          = 'r';
        % ======================================================================= %
    case 'mAb_PBPK_KDModel_2KD_factor2_IVIG' %output IVIG
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'd';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;                        % duration of iv infusion
        single_dose.interval  = 60 ;                        % multiple dosing interval
        
        dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
        dosing.drug  = 'mAb7E3';
        dosing.dose  = 8;
        dosing.route = 'iv_bolus';
        
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
            dosing(2).time  = 0;
        end;
        
        
        
        id=0;
        
        %%%KD Model with 3 drugs but different affinity KD 750 vs 82  nM,
        %%%compund=IgG
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 0;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'b';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     = 'yes';
        individual(id).stdout.compound      = 'IgG';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 1000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'k';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     ='yes';
        individual(id).stdout.compound      = 'IgG';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 2000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'g';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     ='yes';
        individual(id).stdout.compound      = 'IgG';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 400;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'r';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     ='yes';
        individual(id).stdout.compound      = 'IgG';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        % ======================================================================= %
    case 'mAb_PBPK_KDModel_2KD_factor10_IgGendo'%output IgGendo
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'd';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;                        % duration of iv infusion
        single_dose.interval  = 60 ;                        % multiple dosing interval
        
        dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
        dosing.drug  = 'mAb7E3';
        dosing.dose  = 8;
        dosing.route = 'iv_bolus';
        
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
            dosing(2).time  = 0;
        end;
        
        
        
        
        id=0;
        %%%KD Model with 3 drugs but different affinity KD 750 vs 82  nM,
        %%%compound =IgGendo
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 0;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'b';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs82      = 'yes';
        individual(id).stdout.compound      = 'IgGendo';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 400;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'r';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs82      ='yes';
        individual(id).stdout.compound      = 'IgGendo';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 1000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'k';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs82      = 'yes';
        individual(id).stdout.compound      = 'IgGendo';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 2000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'g';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs82      = 'yes';
        individual(id).stdout.compound      = 'IgGendo';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        % ======================================================================= %
        
    case 'mAb_PBPK_KDModel_2KD_factor2_IgGendo'
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'd';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;                        % duration of iv infusion
        single_dose.interval  = 60 ;                        % multiple dosing interval
        
        dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
        dosing.drug  = 'mAb7E3';
        dosing.dose  = 8;
        dosing.route = 'iv_bolus';
        
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
            dosing(2).time  = 0;
        end;
        
        
        id=0;
        
        
        %%%KD Model with 3 drugs but different affinity KD 750 vs 375  nM,
        %%%compund =IgGendo
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 0;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'b';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     = 'yes';
        individual(id).stdout.compound      = 'IgGendo';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 400;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'r';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     = 'yes';
        individual(id).stdout.compound      = 'IgGendo';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 1000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'k';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     = 'yes';
        individual(id).stdout.compound      = 'IgGendo';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 2000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'g';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     ='yes';
        individual(id).stdout.compound      = 'IgGendo';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        % ======================================================================= %
    case 'mAb_PBPK_KDModel_2KD_factor1_IgGendo'
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'd';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;                        % duration of iv infusion
        single_dose.interval  = 60 ;                        % multiple dosing interval
        
        dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
        dosing.drug  = 'mAb7E3';
        dosing.dose  = 8;
        dosing.route = 'iv_bolus';
        
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
            dosing(2).time  = 0;
        end;
        
        
        id=0;
        
        
        %%%KD Model with 3 drugs but different affinity KD 750 vs 375  nM,
        %%%compund =IgGendo
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 0;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'b';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD48foralldrugs='yes';
        individual(id).stdout.compound      = 'IgGendo';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 400;
        individual(id).model.type           ='mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'r';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD48foralldrugs='yes';
        individual(id).stdout.compound      = 'IgGendo';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 1000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'k';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD48foralldrugs='yes';
        individual(id).stdout.compound      = 'IgGendo';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        id=id+1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 2000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'g';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD48foralldrugs='yes';
        individual(id).stdout.compound      = 'IgGendo';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        % ======================================================================= %
        
    case 'mAb_PBPK_Modelcomparison_WTmice_differentKD_inset'%comparison Kd Model with KD 750 nM, KD model with KD750 vs 735 nM
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'd';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;                        % duration of iv infusion
        single_dose.interval  = 60 ;                        % multiple dosing interval
        
        dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
        dosing.drug  = 'mAb7E3';
        dosing.dose  = 8;
        dosing.route = 'iv_bolus';
        
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
        end;
        
        
        
        
        
        
        
        %%%KD Model with 3 drugs but same affinity KD750 nM
        id=1;
        individual(id).species                = reference.mouse.male_25g;
        individual(id).dosing                 = dosing;
        individual(id).dosing(1).dose         = 8;
        individual(id).dosing(2).dose         = 0;
        individual(id).model.type             = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                  = 'b-';
        individual(id).model.FcRn_status      = 'wild-type';
        individual(id).estimation.modus       = 'off';
        individual(id).estimation.expIds      = 10;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice         = 'no';
        individual(id).model.Rat              = 'no';
        individual(id).model.WTmice           = 'yes';
        individual(id).model.NudeMice         = 'no';
        individual(id).model.KD750foralldrugs ='yes';
        individual(id).stdout.compound        ='mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        id=2;
        individual(id).species                = reference.mouse.male_25g;
        individual(id).dosing                 = dosing;
        individual(id).dosing(1).dose         = 8;
        individual(id).dosing(2).dose         = 2000;
        individual(id).model.type             = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                  = 'g-';
        individual(id).model.FcRn_status      = 'wild-type';
        individual(id).estimation.modus       = 'off';
        individual(id).estimation.expIds      = 11;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice         = 'no';
        individual(id).model.Rat              = 'no';
        individual(id).model.WTmice           = 'yes';
        individual(id).model.NudeMice         = 'no';
        individual(id).model.KD750foralldrugs ='yes';
        individual(id).stdout.compound        = 'mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        
        id=3;
        individual(id).species                = reference.mouse.male_25g;
        individual(id).dosing                 = dosing;
        individual(id).dosing(1).dose         = 8;
        individual(id).dosing(2).dose         = 400;
        individual(id).model.type             = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                  = 'r-';
        individual(id).model.FcRn_status      = 'wild-type';
        individual(id).estimation.modus       = 'off';
        individual(id).estimation.expIds      = 12;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice         = 'no';
        individual(id).model.Rat              = 'no';
        individual(id).model.WTmice           = 'yes';
        individual(id).model.NudeMice         = 'no';
        individual(id).model.KD750foralldrugs ='yes';
        individual(id).stdout.compound        = 'mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        %%KD Model with 3 drugs but same affinity KD4.8 nM
        id=4;
        individual(id).species               = reference.mouse.male_25g;
        individual(id).dosing                = dosing;
        individual(id).dosing(1).dose        = 8;
        individual(id).dosing(2).dose        = 0;
        individual(id).model.type            = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                 = 'b.';
        individual(id).model.FcRn_status     = 'wild-type';
        individual(id).estimation.modus      = 'off';
        individual(id).estimation.expIds     = 10;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice        = 'no';
        individual(id).model.Rat             = 'no';
        individual(id).model.WTmice          = 'yes';
        individual(id).model.NudeMice        = 'no';
        individual(id).model.KD48foralldrugs ='yes';
        individual(id).stdout.compound       = 'mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        id=5;
        individual(id).species               = reference.mouse.male_25g;
        individual(id).dosing                = dosing;
        individual(id).dosing(1).dose        = 8;
        individual(id).dosing(2).dose        = 2000;
        individual(id).model.type            = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                 = 'g.';
        individual(id).model.FcRn_status     = 'wild-type';
        individual(id).estimation.modus      = 'off';
        individual(id).estimation.expIds     = 11;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice        = 'no';
        individual(id).model.Rat             = 'no';
        individual(id).model.WTmice          = 'yes';
        individual(id).model.NudeMice        = 'no';
        individual(id).model.KD48foralldrugs ='yes';
        individual(id).stdout.compound       = 'mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        
        id=6;
        individual(id).species               = reference.mouse.male_25g;
        individual(id).dosing                = dosing;
        individual(id).dosing(1).dose        = 8;
        individual(id).dosing(2).dose        = 400;
        individual(id).model.type            = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                 = 'r.';
        individual(id).model.FcRn_status     = 'wild-type';
        individual(id).estimation.modus      = 'off';
        individual(id).estimation.expIds     = 12;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice        = 'no';
        individual(id).model.Rat             = 'no';
        individual(id).model.WTmice          = 'yes';
        individual(id).model.NudeMice        = 'no';
        individual(id).model.KD48foralldrugs ='yes';
        individual(id).stdout.compound       = 'mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        
        %%%KD Model with 3 drugs but different affinity KD 750 vs 375  nM
        id=7;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 0;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'b--';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = 10;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     ='yes';
        individual(id).stdout.compound      = 'mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        id=8;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 2000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'g--';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = 11;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     ='yes';
        individual(id).stdout.compound      = 'mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        id=9;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 400;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'r--';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = 12;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.Rat            = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750vs375     ='yes';
        individual(id).stdout.compound      = 'mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        id=10;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 0;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_Garg2007';
        individual(id).color          = 'b';
        
        
        id=11;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 2000;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_IVIG2_Garg2007';
        individual(id).color          = 'g';
        
        
        
        id=12;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 400;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_IVIG04_Garg2007';
        individual(id).color          = 'r';
        
        
        % ======================================================================= %
    case 'mAb_PBPK_SCIDmice_highFcRn_IVIG'
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'min';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;
        single_dose.interval  = NaN ;
        
        dosing       = single_dose;
        dosing.drug  = 'mAb8C2';
        dosing.dose  = 25;
        dosing.route = 'iv_bolus';
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
        end;
        
        
        speciestype = reference.mouse.male_25g;
        id=0;
        
        
        %%%%KD-model with high FcRn
        
        %%Dose 1 mg/kg
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 8;
        individual(id).dosing(2).dose                   = 0;
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                            = 'b-';
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).estimation.modus                 = 'off';
        individual(id).estimation.expIds                = id+1;
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'yes';
        individual(id).model.SCIDmice_highFcRn          = 'yes';
        individual(id).model.Rat                        = 'no';
        individual(id).model.WTmice                     = 'no';
        individual(id).model.NudeMice                   = 'no';
        individual(id).model.KD750foralldrugs           = 'yes';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        %%Dose 25 mg/kg
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 8;
        individual(id).dosing(2).dose                   = 1000;
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                            = 'bo';
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).estimation.modus                 = 'off';
        individual(id).estimation.expIds                = id+1;
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'yes';
        individual(id).model.SCIDmice_highFcRn          = 'yes';
        individual(id).model.Rat                        = 'no';
        individual(id).model.WTmice                     = 'no';
        individual(id).model.NudeMice                   = 'no';
        individual(id).model.KD750foralldrugs           ='yes';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 8;
        individual(id).dosing(2).dose                   = 2000;
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                            = 'k--';
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).estimation.modus                 = 'off';
        individual(id).estimation.expIds                = id+1;
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'yes';
        individual(id).model.SCIDmice_highFcRn          = 'yes';
        individual(id).model.Rat                        = 'no';
        individual(id).model.WTmice                     = 'no';
        individual(id).model.NudeMice                   = 'no';
        individual(id).model.KD750foralldrugs           ='yes';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        % ======================================================================= %
    case 'mAb_PBPK_SCIDmice_lowFcRn_IVIG'
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'min';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;
        single_dose.interval  = NaN ;
        
        dosing       = single_dose;
        dosing.drug  = 'mAb8C2';
        dosing.dose  = 25;
        dosing.route = 'iv_bolus';
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
        end;
        
        
        speciestype = reference.mouse.male_25g;
        id=0;
        
        
        %%%%KD-model with low FcRn
        
        %%Dose 1 mg/kg
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 8;
        individual(id).dosing(2).dose                   = 0;
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                            = 'b-';
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'yes';
        individual(id).model.SCIDmice_lowFcRn           = 'yes';
        individual(id).model.Rat                        = 'no';
        individual(id).model.WTmice                     = 'no';
        individual(id).model.NudeMice                   = 'no';
        individual(id).model.KD750foralldrugs           ='yes';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        %%Dose 25 mg/kg
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 8;
        individual(id).dosing(2).dose                   = 1000;
        individual(id).model.type                       ='mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                            = 'bo';
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'yes';
        individual(id).model.SCIDmice_lowFcRn           = 'yes';
        individual(id).model.Rat                        = 'no';
        individual(id).model.WTmice                     = 'no';
        individual(id).model.NudeMice                   = 'no';
        individual(id).model.KD750foralldrugs           ='yes';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 8;
        individual(id).dosing(2).dose                   = 2000;
        individual(id).model.type                       ='mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                            = 'k--';
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'yes';
        individual(id).model.SCIDmice_lowFcRn           = 'yes';
        individual(id).model.Rat                        = 'no';
        individual(id).model.WTmice                     = 'no';
        individual(id).model.NudeMice                   = 'no';
        individual(id).model.KD750foralldrugs           ='yes';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        % ======================================================================= %
        
    case 'mAb_PBPK_NUDEmice_lowFcRn_IVIG'
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                        % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'min';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;
        single_dose.interval  = NaN;
        
        dosing       = single_dose;
        dosing.drug  = 'mAbMOPC21';
        dosing.dose  =8;
        dosing.route = 'iv_bolus';
        
        speciestype = reference.mouse.male_25g;
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
        end;
        id=0;
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.022;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 8;
        individual(id).dosing(2).dose                   = 0;
        individual(id).model.type                       =  'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                            = 'b-';
        individual(id).estimation.modus                 = 'off';
        individual(id).estimation.expIds                = id+1;
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'no';
        individual(id).model.Rat                        = 'no';
        individual(id).model.WTmice                     = 'no';
        individual(id).model.NudeMice                   = 'yes';
        individual(id).model.NudeMice_lowFcRn           = 'yes';
        individual(id).model.KD750foralldrugs           ='yes';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.022;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 8;
        individual(id).dosing(2).dose                   = 1000;
        individual(id).model.type                       =  'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                            = 'bo';
        individual(id).estimation.modus                 = 'off';
        individual(id).estimation.expIds                = id+1;
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'no';
        individual(id).model.Rat                        = 'no';
        individual(id).model.WTmice                     = 'no';
        individual(id).model.NudeMice                   = 'yes';
        individual(id).model.NudeMice_lowFcRn           = 'yes';
        individual(id).model.KD750foralldrugs           = 'yes';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.022;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 8;
        individual(id).dosing(2).dose                   = 2000;
        individual(id).model.type                       =  'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                            = 'k--';
        individual(id).estimation.modus                 = 'off';
        individual(id).estimation.expIds                = id+1;
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'no';
        individual(id).model.Rat                        = 'no';
        individual(id).model.WTmice                     = 'no';
        individual(id).model.NudeMice                   = 'yes';
        individual(id).model.NudeMice_lowFcRn           = 'yes';
        individual(id).model.KD750foralldrugs           = 'yes';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        % ======================================================================= %
        
        
    case 'mAb_PBPK_NUDEmice_highFcRn_IVIG'
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                        % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'min';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;
        single_dose.interval  = NaN;
        
        dosing       = single_dose;
        dosing.drug  = 'mAbMOPC21';
        dosing.dose  = 8;
        dosing.route = 'iv_bolus';
        
        speciestype = reference.mouse.male_25g;
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
        end;
        id=0;
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.022;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   =8;
        individual(id).dosing(2).dose                   = 0;
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                            = 'b-';
        individual(id).estimation.modus                 = 'off';
        individual(id).estimation.expIds                = id+1;
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'no';
        individual(id).model.Rat                        = 'no';
        individual(id).model.WTmice                     = 'no';
        individual(id).model.NudeMice                   = 'yes';
        individual(id).model.NudeMice_highFcRn          = 'yes';
        individual(id).model.KD750foralldrugs           ='yes';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.022;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 8;
        individual(id).dosing(2).dose                   = 1000;
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                            = 'bo';
        individual(id).estimation.modus                 = 'off';
        individual(id).estimation.expIds                = id+1;
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'no';
        individual(id).model.Rat                        = 'no';
        individual(id).model.WTmice                     = 'no';
        individual(id).model.NudeMice                   = 'yes';
        individual(id).model.NudeMice_highFcRn          = 'yes';
        individual(id).model.KD750foralldrugs           ='yes';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.022;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 8;
        individual(id).dosing(2).dose                   = 2000;
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                            = 'k--';
        individual(id).estimation.modus                 = 'off';
        individual(id).estimation.expIds                = id+1;
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'no';
        individual(id).model.Rat                        = 'no';
        individual(id).model.WTmice                     = 'no';
        individual(id).model.NudeMice                   = 'yes';
        individual(id).model.NudeMice_highFcRn          = 'yes';
        individual(id).model.KD750foralldrugs           ='yes';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        % ======================================================================= %
        
        
    case 'mAb_PBPK_CutoffModel'
        
        
        speciestype = reference.mouse.male_25g; % Brown et al mouse
        
        
        
        
        showAlsoWTmice   =0;
        showAlsoSCID     =0;
        showAlsoNude     =1;
        
        
        id=0;
        if showAlsoWTmice
            
            single_dose.drug      = [];
            single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
            single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
            single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
            single_dose.time      = 0;                          % time of first administration
            single_dose.timeUnit  = 'd';
            single_dose.repeats   = 1;                          % number of administration events
            single_dose.Tinf      = NaN;                        % duration of iv infusion
            single_dose.interval  = 60 ;                        % multiple dosing interval
            
            dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
            dosing.drug  = 'mAb7E3';
            dosing.dose  = 8;
            dosing.route = 'iv_bolus';
            
            
            IVIG_therapy = 1;
            if IVIG_therapy
                dosing(2)       = dosing(1);
                dosing(2).drug  = 'IVIG';
                dosing(2).dose  = 1000;
            end;
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 8;
            individual(id).dosing(2).dose                   = 0;
            individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_IgGendo';
            individual(id).color                            = 'b';
            individual(id).model.FcRn_status                = 'wild-type';
            individual(id).estimation.modus                 = 'off';
            individual(id).estimation.expIds                = id+1;
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='no';
            individual(id).model.Rat                        ='no';
            individual(id).model.WTmice                     ='yes';
            individual(id).model.NudeMice                   ='no';
            individual(id).model.CutoffModel                ='yes';
            individual(id).model.Estimation_plasmaData      ='yes';
            
            
            
            id=id+1;
            individual(id).species                           = speciestype;
            individual(id).dosing                            = dosing;
            individual(id).dosing(1).dose                    = 8;
            individual(id).dosing(2).dose                    = 0;
            individual(id).model.type                        = 'ExperimentalData';
            individual(id).model.filename                    = 'ExperimentalData_mouse_wt_mAb7E3_Garg2007';
            individual(id).color                             = 'b';
            
            
            
            id=id+1;
            individual(id).species                               = speciestype;
            individual(id).dosing                                = dosing;
            individual(id).dosing(1).dose                        = 8;
            individual(id).dosing(2).dose                        = 1000;
            individual(id).model.type                            = 'mAb_PBPK_11CMT_extravasLim_int_IgGendo';
            individual(id).color                                 = 'k';
            individual(id).model.FcRn_status                     = 'wild-type';
            individual(id).estimation.modus                      = 'off';
            individual(id).estimation.expIds                     = id+1;
            individual(id).stdout.correct_for_residual_blood     = 'no';
            individual(id).stdout.compound                       = 'mAb';
            individual(id).model.SCIDmice                        ='no';
            individual(id).model.Rat                             ='no';
            individual(id).model.WTmice                          ='yes';
            individual(id).model.NudeMice                        ='no';
            individual(id).model.CutoffModel                     ='yes';
            individual(id).model.Estimation_plasmaData           ='yes';
            
            
            
            
            id=id+1;
            individual(id).species                            = speciestype;
            individual(id).dosing                             = dosing;
            individual(id).dosing(1).dose                     = 8;
            individual(id).dosing(2).dose                     = 1000;
            individual(id).model.type                         = 'ExperimentalData';
            individual(id).model.filename                     ='ExperimentalData_mouse_wt_mAb7E3_IVIG1_Garg2007';
            individual(id).color                              = 'k';
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 8;
            individual(id).dosing(2).dose                   = 2000;
            individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_IgGendo';
            individual(id).color                            = 'g';
            individual(id).model.FcRn_status                = 'wild-type';
            individual(id).estimation.modus                 = 'off';
            individual(id).estimation.expIds                = id+1;
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='no';
            individual(id).model.Rat                        ='no';
            individual(id).model.WTmice                     ='yes';
            individual(id).model.NudeMice                   ='no';
            individual(id).model.CutoffModel                ='yes';
            individual(id).model.Estimation_plasmaData      ='yes';
            
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   =8;
            individual(id).dosing(2).dose                   =2000;
            individual(id).model.type                       = 'ExperimentalData';
            individual(id).model.filename                   ='ExperimentalData_mouse_wt_mAb7E3_IVIG2_Garg2007';
            individual(id).color                            = 'g';
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   =8;
            individual(id).dosing(2).dose                   =400;
            individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_IgGendo';
            individual(id).color                            = 'r';
            individual(id).model.FcRn_status                = 'wild-type';
            individual(id).estimation.modus                 = 'off';
            individual(id).estimation.expIds                = id+1;
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='no';
            individual(id).model.Rat                        ='no';
            individual(id).model.WTmice                     ='yes';
            individual(id).model.NudeMice                   ='no';
            individual(id).model.CutoffModel                ='yes';
            individual(id).model.Estimation_plasmaData      ='yes';
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   =8;
            individual(id).dosing(2).dose                   =400;
            individual(id).model.type                       = 'ExperimentalData';
            individual(id).model.filename                   ='ExperimentalData_mouse_wt_mAb7E3_IVIG04_Garg2007';
            individual(id).color                            = 'r';
            
        end;
        
        
        if showAlsoSCID
            
            single_dose.drug      = [];
            single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
            single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
            single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
            single_dose.time      = 0;                          % time of first administration
            single_dose.timeUnit  = 'min';
            single_dose.repeats   = 1;                          % number of administration events
            single_dose.Tinf      = NaN;
            single_dose.interval  = NaN ;
            
            dosing       = single_dose;
            dosing.drug  = 'mAb8C2';
            dosing.dose  = 25;
            dosing.route = 'iv_bolus';
            
            
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.019;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   =1*0.5789;
            individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_IgGendo';
            individual(id).color                            = 'b';
            individual(id).model.FcRn_status                = 'wild-type';
            individual(id).estimation.modus                 = 'off';
            individual(id).estimation.expIds                = id+1;
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='yes';
            individual(id).model.Rat                        ='no';
            individual(id).model.WTmice                     ='no';
            individual(id).model.NudeMice                   ='no';
            individual(id).model.CutoffModel                ='yes';
            individual(id).model.Estimation_plasmaData      ='yes';
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.019;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 1*0.5789;
            individual(id).model.type                       = 'ExperimentalData';
            individual(id).model.filename                   = 'ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose1mgkg';
            individual(id).color                            = 'b';
            
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.019;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 25;
            individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_IgGendo';
            individual(id).color                            = 'r';
            individual(id).model.FcRn_status                = 'wild-type';
            individual(id).estimation.modus                 = 'off';
            individual(id).estimation.expIds                = id+1;
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='yes';
            individual(id).model.Rat                        ='no';
            individual(id).model.WTmice                     ='no';
            individual(id).model.NudeMice                   ='no';
            individual(id).model.CutoffModel                ='yes';
            individual(id).model.Estimation_plasmaData      ='yes';
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.019;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   =25;
            individual(id).model.type                       = 'ExperimentalData';
            individual(id).model.filename                   ='ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose25mgkg';
            individual(id).color                            = 'r';
        end;
        
        if  showAlsoNude
            
            single_dose.drug      = [];
            single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
            single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
            single_dose.doseUnit  ='mg';                        % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
            single_dose.time      = 0;                          % time of first administration
            single_dose.timeUnit  = 'min';
            single_dose.repeats   = 1;                          % number of administration events
            single_dose.Tinf      = NaN;
            single_dose.interval  = NaN;
            
            dosing       = single_dose;
            dosing.drug  = 'mAbMOPC21';
            dosing.dose  = 0.0038;
            dosing.route = 'iv_bolus';
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.022;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 0.0038*0.7419;
            individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_IgGendo';
            individual(id).color                            = 'b';
            individual(id).model.FcRn_status                = 'wild-type';
            individual(id).estimation.modus                 = 'off';
            individual(id).estimation.expIds                = id+1;
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='no';
            individual(id).model.Rat                        ='no';
            individual(id).model.WTmice                     ='no';
            individual(id).model.NudeMice                   ='yes';
            individual(id).model.CutoffModel                ='yes';
            individual(id).model.Estimation_plasmaData      ='yes';
            
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.022;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 0.0038*0.7419;
            individual(id).model.type                       = 'ExperimentalData';
            individual(id).model.filename                   = 'ExperimentalData_mouse_nude_mAbMOPC21_Baxter1994';
            individual(id).color                            = 'k';
            
            
            
        end;
        
        % ======================================================================= %
        
    case 'identical_mAb_PBPK_SCID_FcRnplasma'
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'min';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;
        single_dose.interval  = NaN ;
        
        dosing       = single_dose;
        dosing.drug  = 'mAb8C2';
        dosing.dose  = 25;
        dosing.route = 'iv_bolus';
        
        speciestype = reference.mouse.male_25g;
        
        
        for id= 1:1000;
            individual(id).species                           = speciestype;
            individual(id).species.BW                        = 0.019;
            individual(id).pred.timeSpan                     =[0:0.01:1, 1:14];
            individual(id).pred.timeUnit                     = 'd';
            individual(id).dosing                            = dosing;
            individual(id).dosing(1).dose                    = 25;
            individual(id).model.type                        = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
            individual(id).color                             = 'r';
            individual(id).model.SCID                        = 'yes';
            individual(id).estimation.modus                  = 'off';
            individual(id).stdout.correct_for_residual_blood = 'no';
            individual(id).stdout.compound                   = 'mAb';
            individual(id).model.SCIDmice                    ='yes';
            individual(id).model.SCIDmice_lowFcRn            ='yes';
            individual(id).model.WTmice                      ='no';
            individual(id).model.NudeMice                    ='no';
            individual(id).model.variability_sigma_lognormal='yes';
            individual(id).model.variability_ABC            ='yes';
            individual(id).model.variability_fLymph         ='yes';
            individual(id).model.variability_IgGendo        ='yes';
            individual(id).model.variability_CLupla         ='yes';
            individual(id).model.variability_FcRn           ='yes';
            individual(id).model.variability_co             ='yes';
            individual(id).pred.dosegroup                   = 1;
            individual(id).model.KD750foralldrugs           ='yes';
            individual(id).model.Estimation_plasmaData      ='yes';
        end
        
        
        
        for id =1001:2000;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.019;
            individual(id).pred.timeSpan                    = [0:0.01:1, 1:14];
            individual(id).pred.timeUnit                    = 'd';
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 1*0.5789;
            individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
            individual(id).color                            = 'b';
            individual(id).model.SCID                       = 'yes';
            individual(id).estimation.modus                 = 'off';
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='yes';
            individual(id).model.SCIDmice_lowFcRn           ='yes';
            individual(id).model.WTmice                     ='no';
            individual(id).model.NudeMice                   ='no';
            individual(id).model.variability_sigma_lognormal='yes';
            individual(id).model.variability_ABC            ='yes';
            individual(id).model.variability_fLymph         ='yes';
            individual(id).model.variability_IgGendo        ='yes';
            individual(id).model.variability_CLupla         ='yes';
            individual(id).model.variability_FcRn           ='yes';
            individual(id).model.variability_co             ='yes';
            individual(id).pred.dosegroup                   = 2;
            individual(id).model.KD750foralldrugs           ='yes';
            individual(id).model.Estimation_plasmaData      ='yes';
        end;
        
        id=2001;
        individual(id).species                          = speciestype;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 25*1.00;
        individual(id).model.type                       = 'ExperimentalData';
        individual(id).model.filename                   = ' ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose25mgkg';
        individual(id).color                            = 'r';
        
        id=2002;
        individual(id).species                          = speciestype;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 1*0.5789;
        individual(id).model.type                       = 'ExperimentalData';
        individual(id).model.filename                   ='ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose1mgkg';
        individual(id).color                            = 'b';
        
        
        
        % ======================================================================= %
        
    case 'identical_mAb_PBPK_nude_FcRnplasma'
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg';                        % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'min';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;
        single_dose.interval  = NaN;
        
        dosing       = single_dose;
        dosing.drug  = 'mAbMOPC21';
        dosing.dose  = 0.0038;
        dosing.route = 'iv_bolus';
        
        speciestype = reference.mouse.male_25g;
        
        
        
        for id =1:1000
            individual(id).species                           = speciestype;
            individual(id).species.BW                        = 0.022;
            individual(id).pred.timeSpan                     = 0:0.01:6;
            individual(id).pred.timeUnit                     = 'd';
            individual(id).dosing                            = dosing;
            individual(id).dosing(1).dose                    = 0.0038*0.7419;
            individual(id).model.type                        = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
            individual(id).color                             = 'b-';
            individual(id).model.SCID                        = 'no';
            individual(id).estimation.modus                  = 'off';
            individual(id).stdout.correct_for_residual_blood = 'no';
            individual(id).stdout.compound                   = 'mAb';
            individual(id).model.SCIDmice                    ='no';
            individual(id).model.WTmice                      ='no';
            individual(id).model.NudeMice                    ='yes';
            individual(id).model.NudeMice_lowFcRn            ='yes';
            individual(id).model.variability_sigma_lognormal='yes';
            individual(id).model.variability_ABC            ='yes';
            individual(id).model.variability_fLymph         ='yes';
            individual(id).model.variability_IgGendo        ='yes';
            individual(id).model.variability_CLupla         ='yes';
            individual(id).model.variability_FcRn           ='yes';
            individual(id).model.variability_co             ='yes';
            individual(id).pred.dosegroup                   = 1;
            individual(id).model.KD750foralldrugs           ='yes';
            individual(id).model.Estimation_plasmaData      ='yes';
        end;
        
        id=1001;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.022;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 0.0038*0.7419;
        individual(id).model.type                       = 'ExperimentalData';
        individual(id).model.filename                   ='ExperimentalData_mouse_nude_mAbMOPC21_Baxter1994';
        individual(id).color                            = 'k';
        
        % ======================================================================= %
    case 'identical_mAb_PBPK_IVIG04_WTmice'
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'd';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;                        % duration of iv infusion
        single_dose.interval  = 60 ;                        % multiple dosing interval
        
        dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
        dosing.drug  = 'mAb7E3';
        dosing.dose  = 8;
        dosing.route = 'iv_bolus';
        
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
        end;
        
        speciestype = reference.mouse.male_25g; % Brown et al mouse
        
        
        
        for id =1:1000
            individual(id).species                          = speciestype;
            individual(id).pred.timeSpan                    = [0:0.01:1, 1:14];
            individual(id).pred.timeUnit                    = 'd';
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 8;
            individual(id).dosing(2).dose                   = 400;
            individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
            individual(id).color                            = 'r';
            individual(id).model.FcRn_status                = 'wild-type';
            individual(id).estimation.modus                 = 'off';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='no';
            individual(id).model.Rat                        ='no';
            individual(id).model.WTmice                     ='yes';
            individual(id).model.NudeMice                   ='no';
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).model.variability_sigma_lognormal='yes';
            individual(id).model.variability_ABC            ='yes';
            individual(id).model.variability_fLymph         ='yes';
            individual(id).model.variability_IgGendo        ='yes';
            individual(id).model.variability_CLupla         ='yes';
            individual(id).model.variability_FcRn           ='yes';
            individual(id).model.variability_co             ='yes';
            individual(id).model.KD750foralldrugs           ='yes';
            individual(id).pred.dosegroup                   = 1;
            individual(id).model.Estimation_plasmaData      ='yes';
        end;
        
        
        
        
        id=1001;
        individual(id).species                            = speciestype;
        individual(id).dosing                             = dosing;
        individual(id).dosing(1).dose                     = 8;
        individual(id).dosing(2).dose                     = 400;
        individual(id).model.type                         ='ExperimentalData';
        individual(id).model.filename                     ='ExperimentalData_mouse_wt_mAb7E3_IVIG04_Garg2007';
        individual(id).color                              ='r';
        
        % ======================================================================= %
    case 'identical_mAb_PBPK_IVIG_WTmice'
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'd';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;                        % duration of iv infusion
        single_dose.interval  = 60 ;                        % multiple dosing interval
        
        dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
        dosing.drug  = 'mAb7E3';
        dosing.dose  = 8;
        dosing.route = 'iv_bolus';
        
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
        end;
        
        speciestype = reference.mouse.male_25g; % Brown et al mouse
        
        
        
        for id =1:1000
            individual(id).species                          = speciestype;
            individual(id).pred.timeSpan                    = [0:0.01:1, 1:60];
            individual(id).pred.timeUnit                    = 'd';
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 8;
            individual(id).dosing(2).dose                   = 2000;
            individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
            individual(id).color                            = 'g';
            individual(id).model.FcRn_status                = 'wild-type';
            individual(id).estimation.modus                 = 'off';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='no';
            individual(id).model.Rat                        ='no';
            individual(id).model.WTmice                     ='yes';
            individual(id).model.NudeMice                   ='no';
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).model.variability_sigma_lognormal='yes';
            individual(id).model.variability_ABC            ='yes';
            individual(id).model.variability_fLymph         ='yes';
            individual(id).model.variability_IgGendo        ='yes';
            individual(id).model.variability_CLupla         ='yes';
            individual(id).model.variability_FcRn           ='yes';
            individual(id).model.variability_co             ='yes';
            individual(id).model.KD750foralldrugs           ='yes';
            individual(id).pred.dosegroup                   = 1;
            individual(id).model.Estimation_plasmaData      ='yes';
        end;
        
        for id =1001:2000
            individual(id).species                          = speciestype;
            individual(id).pred.timeSpan                    = [0:0.01:1, 1:60];
            individual(id).pred.timeUnit                    = 'd';
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 8;
            individual(id).dosing(2).dose                   = 0;
            individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
            individual(id).color                            = 'b';
            individual(id).model.FcRn_status                = 'wild-type';
            individual(id).estimation.modus                 = 'off';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='no';
            individual(id).model.Rat                        ='no';
            individual(id).model.WTmice                     ='yes';
            individual(id).model.NudeMice                   ='no';
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).model.variability_sigma_lognormal='yes';
            individual(id).model.variability_ABC            ='yes';
            individual(id).model.variability_fLymph         ='yes';
            individual(id).model.variability_IgGendo        ='yes';
            individual(id).model.variability_CLupla         ='yes';
            individual(id).model.variability_FcRn           ='yes';
            individual(id).model.variability_co             ='yes';
            individual(id).model.KD750foralldrugs           ='yes';
            individual(id).pred.dosegroup                   = 2;
            individual(id).model.Estimation_plasmaData      ='yes';
        end;
        
        
        id=2001;
        individual(id).species                            = speciestype;
        individual(id).dosing                             = dosing;
        individual(id).dosing(1).dose                     = 8;
        individual(id).dosing(2).dose                     = 0;
        individual(id).model.type                         ='ExperimentalData';
        individual(id).model.filename                     ='ExperimentalData_mouse_wt_mAb7E3_Garg2007';
        individual(id).color                              ='b';
        
        id=2002;
        individual(id).species                            = speciestype;
        individual(id).dosing                             = dosing;
        individual(id).dosing(1).dose                     = 8;
        individual(id).dosing(2).dose                     = 2000;
        individual(id).model.type                         ='ExperimentalData';
        individual(id).model.filename                     ='ExperimentalData_mouse_wt_mAb7E3_IVIG2_Garg2007';
        individual(id).color                              ='g';
        
        
        
        
        %===============================================================================%
        
    case 'mAb_PBPK_ModelComparison_InfluenceTumor_SCID'
        
        
        
        
        speciestype = reference.mouse.male_25g; % Brown et al mouse
        
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'min';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;
        single_dose.interval  = NaN ;
        
        dosing       = single_dose;
        dosing.drug  = 'mAb8C2';
        dosing.dose  = 25;
        dosing.route = 'iv_bolus';
        id=0;
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 1*0.5789;
        individual(id).pred.timeSpan                    = [0:0.01:1,1:10];
        individual(id).pred.timeUnit                    = 'd';
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int';
        individual(id).color                            = 'b-';
        individual(id).estimation.modus                 = 'off';
        individual(id).estimation.expIds                = id+1;
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCID                       = 'yes';
        individual(id).model.SCIDmice                   = 'yes';
        individual(id).model.Rat                        ='no';
        individual(id).model.WTmice                     ='no';
        individual(id).model.NudeMice                   ='no';
        individual(id).model.Estimation_plasmaData       ='yes';
        individual(id).pred.dosegroup                   =1;
        
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 25;
        individual(id).pred.timeSpan                    =[0:0.01:1, 1:10];
        individual(id).pred.timeUnit                    = 'd';
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int';
        individual(id).color                            = 'b-';
        individual(id).estimation.modus                 = 'off';
        individual(id).estimation.expIds                = id+1;
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCID                       = 'yes';
        individual(id).model.SCIDmice                   ='yes';
        individual(id).model.Rat                        ='no';
        individual(id).model.WTmice                     ='no';
        individual(id).model.NudeMice                   ='no';
        individual(id).model.Estimation_plasmaData       ='yes';
        individual(id).pred.dosegroup                   = 2;
        
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 1*0.5789;
        individual(id).pred.timeSpan                     =[0:0.01:1, 1:10];
        individual(id).pred.timeUnit                    = 'd';
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_Vgrowth_noTar_V';
        individual(id).color                            = 'r--';
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).model.SCID                       = 'yes';
        individual(id).estimation.modus                 = 'off';
        individual(id).estimation.expIds                = id+1;
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   ='yes';
        individual(id).model.WTmice                     ='no';
        individual(id).model.NudeMice                   ='no';
        individual(id).model.tumorgrowth                =6.35e-5;
        individual(id).pred.dosegroup                   = 3;
        
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 25;
        individual(id).pred.timeSpan                     = [0:0.01:1, 1:10];
        individual(id).pred.timeUnit                    = 'd';
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_Vgrowth_noTar_V';
        individual(id).color                            = 'r--';
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).model.SCID                       = 'yes';
        individual(id).estimation.modus                 = 'off';
        individual(id).estimation.expIds                = id+1;
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   ='yes';
        individual(id).model.WTmice                     ='no';
        individual(id).model.NudeMice                   ='no';
        individual(id).model.tumorgrowth                = 6.35e-5;
        individual(id).pred.dosegroup                   = 4;
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 1*0.5789;
        individual(id).model.type                       ='ExperimentalData';
        individual(id).model.filename                   =' ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose1mgkg';
        individual(id).color                            = 'b';
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   =25;
        individual(id).model.type                       = 'ExperimentalData';
        individual(id).model.filename                   ='ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose25mgkg';
        individual(id).color                            = 'r';
        
        
        %===============================================================================%
        
    case 'mAb_PBPK_ModelComparison_InfluenceTumor_NUDE'
        
        speciestype = reference.mouse.male_25g; % Brown et al mouse
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg';                        % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'min';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;
        single_dose.interval  = NaN;
        
        dosing       = single_dose;
        dosing.drug  = 'mAbMOPC21';
        dosing.dose  = 0.0038*0.7419;
        dosing.route = 'iv_bolus';
        
        id=0;
        id=id+1;
        individual(id).species                           = speciestype;
        individual(id).species.BW                        = 0.022;
        individual(id).dosing                            = dosing;
        individual(id).dosing(1).dose                    = 0.0038*0.7419;
        individual(id).pred.timeSpan                     = [0:0.01:1, 1:6];
        individual(id).pred.timeUnit                     = 'd';
        individual(id).model.type                        = 'mAb_PBPK_11CMT_extravasLim_int';
        individual(id).color                             = 'b-';
        individual(id).model.FcRn_status                 = 'wild-type';
        individual(id).model.SCID                        = 'no';
        individual(id).estimation.modus                  = 'off';
        individual(id).estimation.expIds                 = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).stdout.compound                   = 'mAb';
        individual(id).model.SCIDmice                    ='no';
        individual(id).model.Rat                         ='no';
        individual(id).model.WTmice                      ='no';
        individual(id).model.NudeMice                    ='yes';
        individual(id).model.variability_sigma_lognormal ='no';
        individual(id).model.variability_ABC             ='no';
        individual(id).model.variability_fLymph          ='no';
        individual(id).model.variability_co              ='no';
        individual(id).model.variability_CLpla           ='no';
        individual(id).model.Estimation_plasmaData       ='yes';
        individual(id).pred.dosegroup                    =1;
        
        
        
        
        
        id=id+1;
        individual(id).species                           = speciestype;
        individual(id).species.BW                        = 0.022;
        individual(id).dosing                            = dosing;
        individual(id).dosing(1).dose                    = 0.0038*0.7419;
        individual(id).pred.timeSpan                     = [0:0.01:1, 1:6];
        individual(id).pred.timeUnit                     = 'd';
        individual(id).model.type                        = 'mAb_PBPK_11CMT_extravasLim_int_Vgrowth_noTar_V';
        individual(id).color                             = 'r--';
        individual(id).model.FcRn_status                 = 'wild-type';
        individual(id).model.SCID                        = 'no';
        individual(id).estimation.modus                  = 'off';
        individual(id).estimation.expIds                 = id+1;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).stdout.compound                   = 'mAb';
        individual(id).model.SCIDmice                    ='no';
        individual(id).model.Rat                         ='no';
        individual(id).model.WTmice                      ='no';
        individual(id).model.NudeMice                    ='yes';
        individual(id).model.variability_sigma_lognormal ='no';
        individual(id).model.variability_ABC             ='no';
        individual(id).model.variability_fLymph          ='no';
        individual(id).model.variability_co              ='no';
        individual(id).model.variability_CLpla           ='no';
        individual(id).model.tumorgrowth                 =6.35e-5;
        individual(id).pred.dosegroup                    = 2;
        
        
        
        
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.022;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 0.0038*0.7419;
        individual(id).model.type                       ='ExperimentalData';
        individual(id).model.filename                   ='ExperimentalData_mouse_nude_mAbMOPC21_Baxter1994';
        individual(id).color                            ='k';
        
        
        
        % ======================================================================= %
        
    case 'mAb_PBPK_linearCL'
        
        
        speciestype = reference.mouse.male_25g; % Brown et al mouse
        
        
        id=0;
        
        showAlsoWTmice = 1;
        showAlsoSCID   = 0;
        showAlsoNUDE   = 0;
        
        
        
        if showAlsoWTmice
            
            single_dose.drug      = [];
            single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
            single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
            single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
            single_dose.time      = 0;                          % time of first administration
            single_dose.timeUnit  = 'd';
            single_dose.repeats   = 1;                          % number of administration events
            single_dose.Tinf      = NaN;                        % duration of iv infusion
            single_dose.interval  = 60 ;                        % multiple dosing interval
            
            dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
            dosing.drug  = 'mAb7E3';
            dosing.dose  = 8;
            dosing.route = 'iv_bolus';
            
            
            
            id=id+1;
            individual(id).species                           = speciestype;
            individual(id).species.BWref                     = 0.025;
            individual(id).dosing                            = dosing;
            individual(id).dosing(1).dose                    = 8;
            individual(id).model.type                        = 'mAb_PBPK_11CMT_extravasLim_int';
            individual(id).color                             = 'k-';
            individual(id).model.FcRn_status                 = 'wild-type';
            individual(id).estimation.modus                  = 'off';
            individual(id).estimation.expIds                 = id+1;
            individual(id).stdout.correct_for_residual_blood ='no';
            individual(id).stdout.compound                   ='mAb';
            individual(id).model.SCIDmice                    ='no';
            individual(id).model.Rat                         ='no';
            individual(id).model.WTmice                      ='yes';
            individual(id).model.NudeMice                    ='no';
            individual(id).model.Estimation_plasmaData       ='yes';
            
            id=id+1;
            individual(id).species                         = speciestype;
            individual(id).dosing                          = dosing;
            individual(id).dosing(1).dose                  = 8;
            individual(id).model.type                      = 'ExperimentalData';
            individual(id).model.filename                  = 'ExperimentalData_mouse_wt_mAb7E3_Garg2007';
            individual(id).color                           = 'k';
            
            
        end;
        
        
        
        if showAlsoSCID
            
            single_dose.drug      = [];
            single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
            single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
            single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
            single_dose.time      = 0;                          % time of first administration
            single_dose.timeUnit  = 'min';
            single_dose.repeats   = 1;                          % number of administration events
            single_dose.Tinf      = NaN;
            single_dose.interval  = NaN ;
            
            dosing       = single_dose;
            dosing.drug  = 'mAb8C2';
            dosing.dose  = 25;
            dosing.route = 'iv_bolus';
            
            id=id+1;
            individual(id).species                           = speciestype;
            individual(id).species.BW                        = 0.019;
            individual(id).dosing                            = dosing;
            individual(id).dosing(1).dose                    = 1*0.5789;
            individual(id).model.type                        = 'mAb_PBPK_11CMT_extravasLim_int';
            individual(id).color                             = 'b-';
            individual(id).model.FcRn_status                 = 'wild-type';
            individual(id).model.SCID                        = 'yes';
            individual(id).estimation.modus                  = 'off';
            individual(id).estimation.expIds                 = id+1;
            individual(id).stdout.correct_for_residual_blood = 'no';
            individual(id).stdout.compound                   = 'mAb';
            individual(id).model.SCIDmice                    = 'yes';
            individual(id).model.Rat                         ='no';
            individual(id).model.WTmice                      ='no';
            individual(id).model.NudeMice                    ='no';
            individual(id).model.Estimation_plasmaData      ='yes';
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.019;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 1*0.5789;
            individual(id).model.type                       ='ExperimentalData';
            individual(id).model.filename                   =' ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose1mgkg';
            individual(id).color                            = 'b';
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.019;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 25;
            individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int';
            individual(id).color                            = 'r-';
            individual(id).model.FcRn_status                = 'wild-type';
            individual(id).model.SCID                       = 'yes';
            individual(id).estimation.modus                 = 'off';
            individual(id).estimation.expIds                = id+1;
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='yes';
            individual(id).model.WTmice                     ='no';
            individual(id).model.NudeMice                   ='no';
            individual(id).model.Estimation_plasmaData      ='yes';
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.019;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 25;
            individual(id).model.type                       ='ExperimentalData';
            individual(id).model.filename                   ='ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose25mgkg';
            individual(id).color                            ='r';
            
        end;
        
        
        if showAlsoNUDE
            
            single_dose.drug      = [];
            single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
            single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
            single_dose.doseUnit  ='mg';                        % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
            single_dose.time      = 0;                          % time of first administration
            single_dose.timeUnit  = 'min';
            single_dose.repeats   = 1;                          % number of administration events
            single_dose.Tinf      = NaN;
            single_dose.interval  = NaN;
            
            dosing       = single_dose;
            dosing.drug  ='mAbMOPC21';
            dosing.dose  = 0.0038;
            dosing.route = 'iv_bolus';
            
            id=id+1;
            individual(id).species                           = speciestype;
            individual(id).species.BW                        = 0.022;
            individual(id).dosing                            = dosing;
            individual(id).dosing(1).dose                    = 0.0038*0.7419;
            individual(id).model.type                        = 'mAb_PBPK_11CMT_extravasLim_int';
            individual(id).color                             = 'k-';
            individual(id).model.FcRn_status                 = 'wild-type';
            individual(id).model.SCID                        = 'no';
            individual(id).estimation.modus                  = 'off';
            individual(id).estimation.expIds                 = id+1;
            individual(id).stdout.correct_for_residual_blood = 'no';
            individual(id).stdout.compound                   = 'mAb';
            individual(id).model.SCIDmice                    ='no';
            individual(id).model.Rat                         ='no';
            individual(id).model.WTmice                      ='no';
            individual(id).model.NudeMice                    ='yes';
            individual(id).model.Estimation_plasmaData      ='yes';
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.022;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 0.0038*0.7419;
            individual(id).model.type                       = 'ExperimentalData';
            individual(id).model.filename                   ='ExperimentalData_mouse_nude_mAbMOPC21_Baxter1994';
            individual(id).color                            ='k';
            
        end
        
        % ======================================================================= %
    case 'mAb_PBPK_KDModel'
        
        
        speciestype = reference.mouse.male_25g; % Brown et al mouse
        
        
        
        
        showAlsoWTmice_IVIG     =1;
        showAlsoSCID            =0;
        showAlsoNude            =0;
        
        
        
        if showAlsoWTmice_IVIG
            
            single_dose.drug      = [];
            single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
            single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
            single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
            single_dose.time      = 0;                          % time of first administration
            single_dose.timeUnit  = 'd';
            single_dose.repeats   = 1;                          % number of administration events
            single_dose.Tinf      = NaN;                        % duration of iv infusion
            single_dose.interval  = 60 ;                        % multiple dosing interval
            
            dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
            dosing.drug  = 'mAb7E3';
            dosing.dose  = 8;
            dosing.route = 'iv_bolus';
            
            IVIG_therapy = 1;
            if  IVIG_therapy
                dosing(2)       = dosing(1);
                dosing(2).drug  = 'IVIG';
                dosing(2).dose  = 1000;
            end;
            
            
            
            id=0;
            
            
            
            for id=id+1;
                individual(id).species                          = speciestype;
                individual(id).species.BW                       = 0.025;
                individual(id).dosing                           = dosing;
                individual(id).dosing(1).dose                   = 8;
                individual(id).dosing(2).dose                   = 2000;
                individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
                individual(id).color                            = 'g--';
                individual(id).model.FcRn_status                = 'wild-type';
                individual(id).estimation.modus                 = 'off';
                individual(id).estimation.expIds                = id+1;
                individual(id).stdout.correct_for_residual_blood= 'no';
                individual(id).stdout.compound                  = 'mAb';
                individual(id).model.SCIDmice                   ='no';
                individual(id).model.NudeMice                   ='no';
                individual(id).model.WTmice                     ='yes';
                individual(id).model.KD750vs82                  ='yes';
                individual(id).model.Estimation_plasmaData      ='yes';
                
            end
            
            id=id+1;
            individual(id).species                           = speciestype;
            individual(id).dosing                            = dosing;
            individual(id).dosing(1).dose                    = 8;
            individual(id).model.type                        = 'ExperimentalData';
            individual(id).model.filename                    = 'ExperimentalData_mouse_wt_mAb7E3_IVIG2_Garg2007';
            individual(id).color                             = 'g';
            
            
            for id=id+1;
                individual(id).species                          = speciestype;
                individual(id).species.BW                       = 0.025;
                individual(id).dosing                           = dosing;
                individual(id).dosing(1).dose                   = 8;
                individual(id).dosing(2).dose                   =1000;
                individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
                individual(id).color                            = 'k--';
                individual(id).model.FcRn_status                = 'wild-type';
                individual(id).estimation.modus                 = 'off';
                individual(id).estimation.expIds                = id+1;
                individual(id).stdout.correct_for_residual_blood= 'no';
                individual(id).stdout.compound                  = 'mAb';
                individual(id).model.SCIDmice                   ='no';
                individual(id).model.NudeMice                   ='no';
                individual(id).model.WTmice                     ='yes';
                individual(id).model.KD750vs82                  ='yes';
                individual(id).model.Estimation_plasmaData      ='yes';
                
            end
            
            
            id=id+1;
            individual(id).species                           = speciestype;
            individual(id).dosing                            = dosing;
            individual(id).dosing(1).dose                    = 8;
            individual(id).dosing(2).dose                    = 400;
            individual(id).model.type                        = 'ExperimentalData';
            individual(id).model.filename                    = 'ExperimentalData_mouse_wt_mAb7E3_IVIG1_Garg2007';
            individual(id).color                             = 'k';
            
            for id=id+1;
                individual(id).species                          = speciestype;
                individual(id).species.BW                       = 0.025;
                individual(id).dosing                           = dosing;
                individual(id).dosing(1).dose                   = 8;
                individual(id).dosing(2).dose                   = 400;
                individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
                individual(id).color                            = 'r--';
                individual(id).model.FcRn_status                = 'wild-type';
                individual(id).estimation.modus                 = 'off';
                individual(id).estimation.expIds                = id+1;
                individual(id).stdout.correct_for_residual_blood= 'no';
                individual(id).stdout.compound                  = 'mAb';
                individual(id).model.SCIDmice                   ='no';
                individual(id).model.NudeMice                   ='no';
                individual(id).model.WTmice                     ='yes';
                individual(id).model.KD750vs82                  ='yes';
                individual(id).model.Estimation_plasmaData      ='yes';
                
            end
            
            id=id+1;
            individual(id).species                           = speciestype;
            individual(id).dosing                            = dosing;
            individual(id).dosing(1).dose                    = 8;
            individual(id).dosing(2).dose                    = 400;
            individual(id).model.type                        = 'ExperimentalData';
            individual(id).model.filename                    = 'ExperimentalData_mouse_wt_mAb7E3_IVIG04_Garg2007';
            individual(id).color                             = 'r';
            
            
            
            for id=id+1;
                individual(id).species                          = speciestype;
                individual(id).species.BW                       = 0.025;
                individual(id).dosing                           = dosing;
                individual(id).dosing(1).dose                   = 8;
                individual(id).dosing(2).dose                   = 0;
                individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
                individual(id).color                            = 'b--';
                individual(id).model.FcRn_status                = 'wild-type';
                individual(id).estimation.modus                 = 'off';
                individual(id).estimation.expIds                = id+1;
                individual(id).stdout.correct_for_residual_blood= 'no';
                individual(id).stdout.compound                  = 'mAb';
                individual(id).model.SCIDmice                   ='no';
                individual(id).model.NudeMice                   ='no';
                individual(id).model.WTmice                     ='yes';
                individual(id).model.KD750vs82                  ='yes';
                individual(id).model.Estimation_plasmaData      ='yes';
            end
            
            
            id=id+1;
            individual(id).species                           = speciestype;
            individual(id).dosing                            = dosing;
            individual(id).dosing(1).dose                    = 8;
            individual(id).dosing(2).dose                    = 0;
            individual(id).model.type                        = 'ExperimentalData';
            individual(id).model.filename                    = 'ExperimentalData_mouse_wt_mAb7E3_Garg2007';
            individual(id).color                             = 'b';
            
            
        end;
        
        
        if showAlsoSCID
            
            single_dose.drug      = [];
            single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
            single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
            single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
            single_dose.time      = 0;                          % time of first administration
            single_dose.timeUnit  = 'min';
            single_dose.repeats   = 1;                          % number of administration events
            single_dose.Tinf      = NaN;
            single_dose.interval  = NaN ;
            
            dosing       = single_dose;
            dosing.drug  = 'mAb8C2';
            dosing.dose  = 25;
            dosing.route = 'iv_bolus';
            
            id=0;
            
            
            for id=id+1;
                individual(id).species                          = speciestype;
                individual(id).species.BW                       = 0.019;
                individual(id).dosing                           = dosing;
                individual(id).dosing(1).dose                   = 1*0.5789;
                individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
                individual(id).color                            = 'b-';
                individual(id).estimation.modus                 = 'off';
                individual(id).estimation.expIds                = id+1;
                individual(id).stdout.correct_for_residual_blood= 'no';
                individual(id).stdout.compound                  = 'mAb';
                individual(id).model.SCIDmice                   ='yes';
                individual(id).model.WTmice                     ='no';
                individual(id).model.NudeMice                   ='no';
                individual(id).model.KD750foralldrugs           ='yes';
                individual(id).model.SCIDmice_lowFcRn           ='yes';
                individual(id).model.Estimation_plasmaData      ='yes';
                
            end
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.019;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 1*0.5789;
            individual(id).model.type                       = 'ExperimentalData';
            individual(id).model.filename                   = 'ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose1mgkg';
            individual(id).color                            = 'b';
            
            
            for id=id+1;
                individual(id).species                          = speciestype;
                individual(id).species.BW                       = 0.019;
                individual(id).dosing                           = dosing;
                individual(id).dosing(1).dose                   = 25;
                individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
                individual(id).color                            = 'r-';
                individual(id).estimation.modus                 = 'off';
                individual(id).estimation.expIds                = id+1;
                individual(id).stdout.correct_for_residual_blood= 'no';
                individual(id).stdout.compound                  = 'mAb';
                individual(id).model.SCIDmice                   ='yes';
                individual(id).model.WTmice                     ='no';
                individual(id).model.NudeMice                   ='no';
                individual(id).model.KD750foralldrugs           ='yes';
                individual(id).model.SCIDmice_lowFcRn           ='yes';
                individual(id).model.Estimation_plasmaData      ='yes';
            end
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.019;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 25;
            individual(id).model.type                       = 'ExperimentalData';
            individual(id).model.filename                   ='ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose25mgkg';
            individual(id).color                            = 'r';
            
        end;
        
        if  showAlsoNude
            
            single_dose.drug      = [];
            single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
            single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
            single_dose.doseUnit  ='mg';                        % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
            single_dose.time      = 0;                          % time of first administration
            single_dose.timeUnit  ='min';
            single_dose.repeats   = 1;                          % number of administration events
            single_dose.Tinf      = NaN;
            single_dose.interval  = NaN;
            
            dosing       = single_dose;
            dosing.drug  = 'mAbMOPC21';
            dosing.dose  = 0.0038;
            dosing.route = 'iv_bolus';
            
            id=0;
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.022;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 0.0038*0.7419;
            individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
            individual(id).color                            = 'r';
            individual(id).estimation.modus                 = 'off';
            individual(id).estimation.expIds                = id+1;
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='no';
            individual(id).model.WTmice                     ='no';
            individual(id).model.NudeMice                   ='yes';
            individual(id).model.KD750foralldrugs           ='yes';
            individual(id).model.NudeMice_lowFcRn          ='yes';
            individual(id).model.Estimation_plasmaData      ='yes';
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.022;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 0.0038*0.7419;
            individual(id).model.type                       = 'ExperimentalData';
            individual(id).model.filename                   = 'ExperimentalData_mouse_nude_mAbMOPC21_Baxter1994';
            individual(id).color                            = 'k';
            
            
            
        end;
        % ======================================================================= %
        
    case 'mAb_PBPK_Modelcomparison_WTmice_differentKD_obsvspred' %comparison Kd Model with KD 750 nM, KD model with KD750 vs 735 nM
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'd';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;                        % duration of iv infusion
        single_dose.interval  = 60 ;                        % multiple dosing interval
        
        dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
        dosing.drug  = 'mAb7E3';
        dosing.dose  = 8;
        dosing.route = 'iv_bolus';
        
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
        end;
        
        
        %%%KD Model with 3 drugs but same affinity KD750 nM
        id=1;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 0;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'bo';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = 10;
        individual(id).evaluation.modus     = 'on';
        individual(id).evaluation.expIds    = 10;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750foralldrugs        ='yes';
        individual(id).stdout.compound               = 'mAb';
        individual(id).model.Estimation_plasmaData   ='yes';
        
        
        
        
        id=2;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 2000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'go';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = 11;
        individual(id).evaluation.modus     = 'on';
        individual(id).evaluation.expIds    = 11;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750foralldrugs        ='yes';
        individual(id).stdout.compound               = 'mAb';
        individual(id).model.Estimation_plasmaData   ='yes';
        
        
        
        
        
        id=3;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 400;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'ro';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = 12;
        individual(id).evaluation.modus     = 'on';
        individual(id).evaluation.expIds    = 12;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD750foralldrugs        ='yes';
        individual(id).stdout.compound               = 'mAb';
        individual(id).model.Estimation_plasmaData   ='yes';
        
        
        %%KD Model with 3 drugs but same affinity KD4.8 nM
        id=4;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 0;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'b*';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = 10;
        individual(id).evaluation.modus     = 'on';
        individual(id).evaluation.expIds    = 10;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD48foralldrugs        ='yes';
        individual(id).stdout.compound              = 'mAb';
        individual(id).model.Estimation_plasmaData  ='yes';
        
        
        
        
        id=5;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 2000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'g*';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = 11;
        individual(id).evaluation.modus     = 'on';
        individual(id).evaluation.expIds    = 11;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice       = 'no';
        individual(id).model.WTmice         = 'yes';
        individual(id).model.NudeMice       = 'no';
        individual(id).model.KD48foralldrugs        ='yes';
        individual(id).stdout.compound              = 'mAb';
        individual(id).model.Estimation_plasmaData  ='yes';
        
        
        id=6;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 400;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'r*';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = 12;
        individual(id).evaluation.modus     = 'on';
        individual(id).evaluation.expIds    = 12;
        individual(id).stdout.correct_for_residual_blood = 'no';
        individual(id).model.SCIDmice                    = 'no';
        individual(id).model.WTmice                      = 'yes';
        individual(id).model.NudeMice                    = 'no';
        individual(id).model.KD48foralldrugs             ='yes';
        individual(id).stdout.compound                   = 'mAb';
        individual(id).model.Estimation_plasmaData       ='yes';
        
        
        %%%KD Model with 3 drugs but different affinity KD 750 vs 375  nM
        id=7;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 0;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'bx';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = 10;
        individual(id).evaluation.modus     = 'on';
        individual(id).evaluation.expIds    = 10;
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).model.SCIDmice                   = 'no';
        individual(id).model.WTmice                     = 'yes';
        individual(id).model.NudeMice                   = 'no';
        individual(id).model.KD750vs375                 ='yes';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        id=8;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 2000;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'gx';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = 11;
        individual(id).evaluation.modus     = 'on';
        individual(id).evaluation.expIds    = 11;
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).model.SCIDmice                   = 'no';
        individual(id).model.WTmice                     = 'yes';
        individual(id).model.NudeMice                   = 'no';
        individual(id).model.KD750vs375                 ='yes';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        
        id=9;
        individual(id).species              = reference.mouse.male_25g;
        individual(id).dosing               = dosing;
        individual(id).dosing(1).dose       = 8;
        individual(id).dosing(2).dose       = 400;
        individual(id).model.type           = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD';
        individual(id).color                = 'rx';
        individual(id).model.FcRn_status    = 'wild-type';
        individual(id).estimation.modus     = 'off';
        individual(id).estimation.expIds    = 12;
        individual(id).evaluation.modus     = 'on';
        individual(id).evaluation.expIds    = 12;
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).model.SCIDmice                   = 'no';
        individual(id).model.WTmice                     = 'yes';
        individual(id).model.NudeMice                   = 'no';
        individual(id).model.KD750vs375                 ='yes';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.Estimation_plasmaData      ='yes';
        
        
        
        id=10;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 0;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_Garg2007';
        individual(id).color          = 'b';
        
        
        id=11;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 2000;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_IVIG2_Garg2007';
        individual(id).color          = 'g';
        
        
        id=12;
        individual(id).species        = reference.mouse.male_25g;
        individual(id).dosing         = dosing;
        individual(id).dosing(1).dose = 8;
        individual(id).dosing(2).dose = 400;
        individual(id).model.type     = 'ExperimentalData';
        individual(id).model.filename = 'ExperimentalData_mouse_wt_mAb7E3_IVIG04_Garg2007';
        individual(id).color          = 'r';
        
        
        
        % ======================================================================= %
        
        
    case 'mAb_PBPK_KDmodel_Baseline_all'
        
        speciestype = reference.mouse.male_25g;
        
        
        
        %WT mice, IVIG
        
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'd';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;                        % duration of iv infusion
        single_dose.interval  = 60 ;                        % multiple dosing interval
        
        dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
        dosing.drug  = 'mAb7E3';
        dosing.dose  = 8;
        dosing.route = 'iv_bolus';
        
        
        IVIG_therapy = 1;
        if IVIG_therapy
            dosing(2)       = dosing(1);
            dosing(2).drug  = 'IVIG';
            dosing(2).dose  = 1000;
        end;
        
        id=0;
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 8;
        individual(id).dosing(2).dose                   = 0;
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD_base';
        individual(id).color                            = 'b--';
        individual(id).model.FcRn_status                = 'wild-type';
        individual(id).estimation.modus                 = 'off';% GenericPBPKmodel_estimatePBPKparameters_mAbIgGendo_CLbase
        individual(id).estimation.expIds                = id+1;
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'no';
        individual(id).model.WTmice                     = 'yes';
        individual(id).model.NudeMice                   = 'no';
        individual(id).model.KD750foralldrugs           ='yes';
        
        
        id=id+1;
        individual(id).species                           = speciestype;
        individual(id).dosing                            = dosing;
        individual(id).dosing(1).dose                    = 8;
        individual(id).dosing(2).dose                    = 0;
        individual(id).model.type                        = 'ExperimentalData';
        individual(id).model.filename                    = 'ExperimentalData_mouse_wt_mAb7E3_Garg2007';
        individual(id).color                             = 'b';
        
        
        
        id=id+1;
        individual(id).species                               = speciestype;
        individual(id).dosing                                = dosing;
        individual(id).dosing(1).dose                        = 8;
        individual(id).dosing(2).dose                        = 1000;
        individual(id).model.type                            = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD_base';
        individual(id).color                                 = 'k--';
        individual(id).model.FcRn_status                     = 'wild-type';
        individual(id).estimation.modus                      = 'off';% GenericPBPKmodel_estimatePBPKparameters_mAbIgGendo_CLbase
        individual(id).estimation.expIds                     = id+1;
        individual(id).stdout.correct_for_residual_blood     = 'no';
        individual(id).stdout.compound                       = 'mAb';
        individual(id).model.SCIDmice                        = 'no';
        individual(id).model.WTmice                          = 'yes';
        individual(id).model.NudeMice                        = 'no';
        individual(id).model.KD750foralldrugs                = 'yes';
        
        
        
        
        
        id=id+1;
        individual(id).species                            = speciestype;
        individual(id).dosing                             = dosing;
        individual(id).dosing(1).dose                     = 8;
        individual(id).dosing(2).dose                     = 1000;
        individual(id).model.type                         = 'ExperimentalData';
        individual(id).model.filename                     ='ExperimentalData_mouse_wt_mAb7E3_IVIG1_Garg2007';
        individual(id).color                              = 'k';
        
        
        id=id+1;
        individual(id).species                               = speciestype;
        individual(id).dosing                                = dosing;
        individual(id).dosing(1).dose                        = 8;
        individual(id).dosing(2).dose                        = 2000;
        individual(id).model.type                            = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD_base'; %'mAb_PBPK_11CMT_extravasLim_int_IgGendo_Kd_Base';
        individual(id).color                                 = 'g--';
        individual(id).model.FcRn_status                     = 'wild-type';
        individual(id).estimation.modus                      = 'off';% GenericPBPKmodel_estimatePBPKparameters_mAbIgGendo_CLbase
        individual(id).estimation.expIds                     = id+1;
        individual(id).stdout.correct_for_residual_blood     = 'no';
        individual(id).stdout.compound                       = 'mAb';
        individual(id).model.SCIDmice                        = 'no';
        individual(id).model.WTmice                          = 'yes';
        individual(id).model.NudeMice                        = 'no';
        individual(id).model.KD750foralldrugs                ='yes';
        
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   =8;
        individual(id).dosing(2).dose                   =2000;
        individual(id).model.type                       = 'ExperimentalData';
        individual(id).model.filename                   ='ExperimentalData_mouse_wt_mAb7E3_IVIG2_Garg2007';
        individual(id).color                            = 'g';
        
        
        id=id+1;
        individual(id).species                               = speciestype;
        individual(id).dosing                                = dosing;
        individual(id).dosing(1).dose                        = 8;
        individual(id).dosing(2).dose                        = 400;
        individual(id).model.type                            = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD_base'; %'mAb_PBPK_11CMT_extravasLim_int_IgGendo_Kd_Base';
        individual(id).color                                 = 'r--';
        individual(id).model.FcRn_status                     = 'wild-type';
        individual(id).estimation.modus                      = 'off';% GenericPBPKmodel_estimatePBPKparameters_mAbIgGendo_CLbase
        individual(id).estimation.expIds                     = id+1;
        individual(id).stdout.correct_for_residual_blood     = 'no';
        individual(id).stdout.compound                       = 'mAb';
        individual(id).model.SCIDmice                        = 'no';
        individual(id).model.WTmice                          = 'yes';
        individual(id).model.NudeMice                        = 'no';
        individual(id).model.KD750foralldrugs                ='yes';
        
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   =8;
        individual(id).dosing(2).dose                   =400;
        individual(id).model.type                       = 'ExperimentalData';
        individual(id).model.filename                   ='ExperimentalData_mouse_wt_mAb7E3_IVIG04_Garg2007';
        individual(id).color                            = 'r';
        
        %nude mice
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg';                        % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'd';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;
        single_dose.interval  = NaN;
        
        dosing       = single_dose;
        dosing.drug  = 'mAbMOPC21';
        dosing.dose  = 0.0038;
        dosing.route = 'iv_bolus';
        
        
        
        %%%%Kd Model
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.022;
        individual(id).dosing                           = dosing;
        individual(id).dosing.dose                      = 0.0038*0.7419;
        individual(id).dosing.unit                      = 'mg';
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD_base'; %'mAb_PBPK_11CMT_extravasLim_int_IgGendo_Kd_Base';
        individual(id).color                            = 'r-';
        individual(id).estimation.modus                 = 'off';% GenericPBPKmodel_estimatePBPKparameters_mAbIgGendo_CLbase
        individual(id).estimation.expIds                = id+1;
        individual(id).stdout.correct_for_residual_blood= 'no';%'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   ='no';
        individual(id).model.Rat                        ='no';
        individual(id).model.WTmice                     ='no';
        individual(id).model.NudeMice                   ='yes';
        individual(id).model.KD750foralldrugs           ='yes';
        
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.022;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 0.0038*0.7419;
        individual(id).model.type                       = 'ExperimentalData';
        individual(id).model.filename                   = 'ExperimentalData_mouse_nude_mAbMOPC21_Baxter1994';
        individual(id).color                            = 'k';
        
        %SCID
        single_dose.drug      = [];
        single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
        single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
        single_dose.doseUnit  ='mg/kg BW';                        % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
        single_dose.time      = 0;                          % time of first administration
        single_dose.timeUnit  = 'min';
        single_dose.repeats   = 1;                          % number of administration events
        single_dose.Tinf      = NaN;
        single_dose.interval  = NaN;
        
        dosing       = single_dose;
        dosing.drug  = 'mAb8C2';
        dosing.dose  = 1;
        dosing.route = 'iv_bolus';
        
        speciestype = reference.mouse.male_25g;
        
        %%%%KD-model
        
        %%Dose 1 mg/kg
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 1*0.5789;
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD_base'; %'mAb_PBPK_11CMT_extravasLim_int_IgGendo_Kd_Base';
        individual(id).color                            = 'b-';
        individual(id).estimation.modus                 = 'off';% GenericPBPKmodel_estimatePBPKparameters_mAbIgGendo_CLbase
        individual(id).estimation.expIds                = id+1;
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'yes';
        individual(id).model.WTmice                     = 'no';
        individual(id).model.NudeMice                   = 'no';
        individual(id).model.KD750foralldrugs           ='yes';
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 1*0.5789;
        individual(id).model.type                       = 'ExperimentalData';
        individual(id).model.filename                   = 'ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose1mgkg';
        individual(id).color                            = 'b';
        
        %%Dose 25 mg/kg
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 25;
        individual(id).model.type                       = 'mAb_PBPK_11CMT_extravasLim_int_3Drugs_2KD_base'; %'mAb_PBPK_11CMT_extravasLim_int_IgGendo_Kd_Base';
        individual(id).color                            = 'r-';
        individual(id).estimation.modus                 = 'off';% GenericPBPKmodel_estimatePBPKparameters_mAbIgGendo_CLbase
        individual(id).estimation.expIds                = id+1;
        individual(id).stdout.correct_for_residual_blood= 'no';
        individual(id).stdout.compound                  = 'mAb';
        individual(id).model.SCIDmice                   = 'yes';
        individual(id).model.KD750foralldrugs           ='yes';
        
        
        id=id+1;
        individual(id).species                          = speciestype;
        individual(id).species.BW                       = 0.019;
        individual(id).dosing                           = dosing;
        individual(id).dosing(1).dose                   = 25;
        individual(id).model.type                       = 'ExperimentalData';
        individual(id).model.filename                   = 'ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose25mgkg';
        individual(id).color                            = 'r';
        
        
        
        
        % ======================================================================= %
        
    case 'mAb_PBPK_KDModel_int' %int refers to CL in intestitial space
        
        
        
        
        speciestype = reference.mouse.male_25g; % Brown et al mouse
        
        
        id=0;
        
        showAlsoWTmice = 0;
        showAlsoSCID   = 1;
        
        
        
        
        if showAlsoWTmice
            
            single_dose.drug      = [];
            single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
            single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
            single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
            single_dose.time      = 0;                          % time of first administration
            single_dose.timeUnit  = 'd';
            single_dose.repeats   = 1;                          % number of administration events
            single_dose.Tinf      = NaN;                        % duration of iv infusion
            single_dose.interval  = 60 ;                        % multiple dosing interval
            
            dosing       = single_dose;                          % dose in [mg/kg BW], administration at t=0, time in [h]
            dosing.drug  = 'mAb7E3';
            dosing.dose  =8;
            dosing.route = 'iv_bolus';
            
            
            IVIG_therapy = 1;
            if IVIG_therapy
                dosing(2)       = dosing(1);
                dosing(2).drug  = 'IVIG';
                dosing(2).dose  = 1000;
            end;
            
            id=id+1;
            individual(id).species                           = speciestype;
            individual(id).dosing                            = dosing;
            individual(id).dosing(1).dose                    =8;
            individual(id).dosing(2).dose                    =0;
            individual(id).model.type                        = 'mAb_PBPK_11CMT_extravasLim_int_3Drug_2KD_CLint';
            individual(id).color                             = 'k';
            individual(id).model.FcRn_status                 = 'wild-type';
            individual(id).estimation.modus                  = 'off';
            individual(id).estimation.expIds                 = id+1;
            individual(id).stdout.correct_for_residual_blood = 'no';
            individual(id).stdout.compound                   = 'mAb';
            individual(id).model.SCIDmice                    ='no';
            individual(id).model.WTmice                      ='yes';
            individual(id).model.NudeMice                    ='no';
            individual(id).model.KD48foralldrugs             ='yes';
            
            
            
            id=id+1;
            individual(id).species                         = speciestype;
            individual(id).dosing                          = dosing;
            individual(id).dosing(1).dose                  =8;
            individual(id).dosing(2).dose                  =0;
            individual(id).model.type                      = 'ExperimentalData';
            individual(id).model.filename                  = 'ExperimentalData_mouse_wt_mAb7E3_Garg2007';
            individual(id).color                           = 'k';
            
            
            
            id=id+1;
            individual(id).species                              = speciestype;
            individual(id).dosing                               = dosing;
            individual(id).dosing(1).dose                       =8;
            individual(id).dosing(2).dose                       =1000;
            individual(id).model.type                           =  'mAb_PBPK_11CMT_extravasLim_int_3Drug_2KD_CLint';
            individual(id).color                                = 'r';
            individual(id).model.FcRn_status                    = 'wild-type';
            individual(id).estimation.modus                     = 'off';
            individual(id).estimation.expIds                    = id+1;
            individual(id).stdout.correct_for_residual_blood    = 'no';
            individual(id).stdout.compound                      = 'mAb';
            individual(id).model.SCIDmice                       ='no';
            individual(id).model.WTmice                         ='yes';
            individual(id).model.NudeMice                       ='no';
            individual(id).model.KD48foralldrugs                ='yes';
            
            id=id+1;
            individual(id).species          = speciestype;
            individual(id).dosing           = dosing ;
            individual(id).dosing(1).dose   = 8;
            individual(id).dosing(2).dose   = 1000;
            individual(id).model.type       = 'ExperimentalData';
            individual(id).model.filename   ='ExperimentalData_mouse_wt_mAb7E3_IVIG1_Garg2007';
            individual(id).color            = 'r';
            
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 8;
            individual(id).dosing(2).dose                   = 2000;
            individual(id).model.type                       =  'mAb_PBPK_11CMT_extravasLim_int_3Drug_2KD_CLint';
            individual(id).color                            = 'k';
            individual(id).model.FcRn_status                = 'wild-type';
            individual(id).estimation.modus                 = 'off';
            individual(id).estimation.expIds                = id+1;
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='no';
            individual(id).model.WTmice                     ='yes';
            individual(id).model.NudeMice                   ='no';
            individual(id).model.KD48foralldrugs            ='yes';
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 8;
            individual(id).dosing(2).dose                   = 2000;
            individual(id).model.type                       = 'ExperimentalData';
            individual(id).model.filename                   ='ExperimentalData_mouse_wt_mAb7E3_IVIG2_Garg2007';
            individual(id).color                            = 'k';
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 8;
            individual(id).dosing(2).dose                   = 400;
            individual(id).model.type                       =  'mAb_PBPK_11CMT_extravasLim_int_3Drug_2KD_CLint';
            individual(id).color                            = 'b';
            individual(id).model.FcRn_status                = 'wild-type';
            individual(id).estimation.modus                 = 'off';
            individual(id).estimation.expIds                = id+1;
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='no';
            individual(id).model.WTmice                     ='yes';
            individual(id).model.NudeMice                   ='no';
            individual(id).model.KD48foralldrugs            ='yes';
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 8;
            individual(id).dosing(2).dose                   = 400;
            individual(id).model.type                       = 'ExperimentalData';
            individual(id).model.filename                   ='ExperimentalData_mouse_wt_mAb7E3_IVIG04_Garg2007';
            individual(id).color                            = 'b';
            
        end;
        
        
        
        if showAlsoSCID
            
            single_dose.drug      = [];
            single_dose.route     = [];                         % 'iv_bolus', 'iv_infusion', 'po'
            single_dose.dose      = [];                         % in [mg] or [mg]/per BSD (body size descriptor)'
            single_dose.doseUnit  ='mg/kg BW';                  % 'mg' or 'mg/kg BW', 'mg/kg LBW', 'mg/m2 BSA'
            single_dose.time      = 0;                          % time of first administration
            single_dose.timeUnit  = 'min';
            single_dose.repeats   = 1;                          % number of administration events
            single_dose.Tinf      = NaN;
            single_dose.interval  = NaN ;
            
            dosing       = single_dose;
            dosing.drug  = 'mAb8C2';
            dosing.dose  = 25;
            dosing.route = 'iv_bolus';
            
            id=id+1;
            individual(id).species                           = speciestype;
            individual(id).species.BW                        = 0.019;
            individual(id).dosing                            = dosing;
            individual(id).dosing(1).dose                    =1*0.5789;
            individual(id).model.type                        = 'mAb_PBPK_11CMT_extravasLim_int_3Drug_2KD_CLint';
            individual(id).color                             = 'r';
            individual(id).model.FcRn_status                 = 'wild-type';
            individual(id).model.SCID                        = 'yes';
            individual(id).estimation.modus                  = 'off';
            individual(id).estimation.expIds                 = id+1;
            individual(id).stdout.correct_for_residual_blood = 'no';
            individual(id).stdout.compound                   = 'mAb';
            individual(id).model.SCIDmice                    ='yes';
            individual(id).model.WTmice                      ='no';
            individual(id).model.NudeMice                    ='no';
            individual(id).model.KD48foralldrugs             ='yes';
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.019;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 1*0.5789;
            individual(id).model.type                       = 'ExperimentalData';
            individual(id).model.filename                   = ' ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose1mgkg';
            individual(id).color                            = 'r';
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.019;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 25;
            individual(id).model.type                       ='mAb_PBPK_11CMT_extravasLim_int_3Drug_2KD_CLint';
            individual(id).color                            = 'b';
            individual(id).model.FcRn_status                = 'wild-type';
            individual(id).model.SCID                       = 'yes';
            individual(id).estimation.modus                 = 'off';
            individual(id).estimation.expIds                = id+1;
            individual(id).stdout.correct_for_residual_blood= 'no';
            individual(id).stdout.compound                  = 'mAb';
            individual(id).model.SCIDmice                   ='yes';
            individual(id).model.WTmice                     ='no';
            individual(id).model.NudeMice                   ='no';
            individual(id).model.KD48foralldrugs            ='yes';
            
            
            id=id+1;
            individual(id).species                          = speciestype;
            individual(id).species.BW                       = 0.019;
            individual(id).dosing                           = dosing;
            individual(id).dosing(1).dose                   = 25;
            individual(id).model.type                       = 'ExperimentalData';
            individual(id).model.filename                   ='ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose25mgkg';
            individual(id).color                            = 'b';
            
        end;
        
        
        
        
        
    otherwise
        
        message = 'Unknown approach to generate a virtual population!';
        GenericPBPKmodel_ReportErrorMessage(message);
        
end; % of switch population.how2generate



end
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% END: MAIN FUNCTION
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% BEGIN: LOCAL SUB-ROUTINES





%%% END: LOCAL SUB-ROUTINES
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

