%%% Version: October 31st, 2014
%%% 
%%% This function assigns the drug relevant data
%%% 
%%% For references and citation, please see MAIN script.
%%% 
%%% Copyright (C) 2014, Universitaet Potsdam, Germany
%%% Contact: W. Huisinga, huisinga@uni-potsdam.de
%%%
%%% The program is distributed under the terms of the 
%%% Creative Commons License (CC BY-NC-SA 3.0):
%%% Attribution-NonCommercial-ShareAlike 3.0 Unported 
%%%
%%% For a SHORT HUMAN-READABLE SUMMARY OF THE LEGAL CODE, see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/
%%%
%%% For the Legal Code (the full license) see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/legalcode
%%%
%%%


%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% BEGIN: MAIN FUNCTION
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

function SF = GenericPBPKmodel_ScalingFactor2internalUnits(unit)

switch unit
    
    %%% -------------------------------------------------------------------
    %%% time units
    case 'min';
        SF = 1;
    case 'h';         % [h] = 60 [min]
        SF = 60;
    case 'd';         % [d] = 60*24 [min]
        SF = 60*24;
    case 'w';         % [w] = 60*24*7 [min]
        SF = 60*24*7;
    
        
    %%% -------------------------------------------------------------------
    %%% units of rate constants
    case '1/min';
        SF = 1;
    case '1/h';       % [1/h] = 1/60 [1/min]
        SF = 1/60;
    case '1/d';       % [1/d] = 1/(60*24) [1/min]
        SF = 1/(60*24);
        
        
    %%% -------------------------------------------------------------------
    %%% flow units
    case 'L/min'; 
        SF = 1;
    case 'mL/min';    % [mL/min] = [1e-3 L/min] = 1e-3 [L/min]
        SF = 1e-3;
    case 'mL/d';      % [mL/d] = [1e-3 L/((60*24) min)] = 1e-3/(60*24) [L/min]
        SF = 1e-3/(60*24);
    case 'L/h';       % [L/h] = [L/(60*min)] = 1/60 [L/min]
        SF = 1/60;
        
        
    %%% -------------------------------------------------------------------
    %%% mass units
    case 'nmol';
        SF = 1;        

    case 'umol';        % [umol] = [1e-6 mol] = 1e-6 [1e9 nmol] = 1e3 [nmol]
        SF = 1e3;        

    case 'mmol';        % [mmol] = [1e-3 mol] = 1e-3 [1e9 nmol] = 1e6 [nmol]
        SF = 1e6;        

    case 'mg';          % [mg] = mg/mmol [mmol] = g/mol * [1e-3 mol] = 1/MW * 1e-3 [1e9 nmol] = 1e6/MW [nmol]
        SF = 1e6 / MW;        

    case 'ug';          % [ug] = ug/umol [umol] = g/mol * [1e-6 mol] = 1/MW * 1e-6 [1e9 nmol] = 1e3/MW [nmol]
        SF = 1e3 / MW;        

        
    %%% -------------------------------------------------------------------
    %%% concentration units
    case 'nM';
        SF = 1;        

    case 'uM';        % [uM] = [1e-6 M] = 1e-6 [1e9 nM] = 1e3 [nM]
        SF = 1e3;        

    case 'mM';        % [mM] = [1e-3 M] = 1e-3 [1e9 nM] = 1e6 [nM]
        SF = 1e6;        

    case 'mg/L';      % [mg/L] = mg/mmol [mmol/L] = 1/MW * [1e-3 M] = 1e-3/MW [1e9 nM] = MW 1e6 [nM]
        SF = 1e6 / MW;        

    case 'ug/ml';
        SF=  1e6 / MW; 
        
    case 'ng/mL';     % [ng/mL] = g/mol [nmol/(1e-3 L)] = 1e3/MW [nM]
        SF = 1e3 / MW;        

        
 
    %%% -------------------------------------------------------------------
    %%% BW normalized clearance units
    case 'L/min per kg BW'; % ppm -> nM
        SF = 1;
    case 'mL/min per kg BW'; % ppm -> nM
        SF = 1e-3;

    %%% -------------------------------------------------------------------
    %%% exposure units
    %%% SF based on Abraham etal,
    %%% ppm2mg/L = ppm*MW/24450 => ppm2ng/L = ppm*MW 1e6/24450
    %%% hence ppm2nmol/L = ppm * 1e6/24450
    case 'ppm'; % ppm -> nM
        SF = 1e6 / 24450; 

        
    %%% -------------------------------------------------------------------
    %%% unknown units
    otherwise
        message = sprintf('Unknown unit to be scaled! Update GenericPBPKmodel_ScalingFactor2internalUnits.m');
        GenericPBPKmodel_ReportErrorMessage(message);
end;

end





%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% END: MAIN FUNCTION
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% BEGIN: LOCAL SUB-ROUTINES

%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function out = GenericPBPKmodel_localfunction(input)
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

%%% just a template for potential future use

end

%%% END: LOCAL SUB-ROUTINES
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

