%%% Version: October 31st, 2014
%%%
%%% Experimental data
%%% 
%%% Experimental data
%%% 
%%% Species: mouse, 25g, wild-type,  C57BL/6J strain

%%% Drug:    mAb7E3, murine IgG1, anti-platelet mAb with a
%%%          high affinity for the human glycoprotein IIb/IIIa, 
%%%          does not bind to the murine glycoprotein IIb/IIIa

%%% Study:   125I-labeled 7E3 8 mg/kg BW, i.v. single bolus dosing

%%% Units:   time in [day], concentration in [nmol/L]

%%% Source:  digitized graphics from Garg, PhD thesis (2007) Chapter 3,Fig.3

function expdata = ExperimentalData_mouse_wt_mAb7E3_Garg2007


%%% -----------------------------------------------------------------------
%%% Species 
%%%

expdata.species.type   = 'mouse';
expdata.species.BW     = 0.025;   % in [kg]
expdata.species.FcRn_status = 'wild-type';


%%% -----------------------------------------------------------------------
%%% dosing information
%%%

dosing.drug      = 'mAb7E3';
dosing.route     = 'iv_bolus';
dosing.dose      = 8;
dosing.doseUnit  = 'mg/kg BW'; 
dosing.time      = 0;    
dosing.timeUnit  = 'd';
dosing.repeats   = 1;       
dosing.Tinf      = NaN;           % duration of iv infusion 
dosing.interval  = NaN;           % multiple dosing interval 

expdata.dosing   = dosing;


%%% -----------------------------------------------------------------------
%%% time information
%%%

pred.timeSpan = [0 60*24*60];
pred.timeUnit = 'd';

expdata.pred  = pred;


%%% -----------------------------------------------------------------------
%%% units and scaling factors
%%%
expdata.unit.t = 'day';
expdata.unit.C = 'nM';

expdata.SF.time_to_min = 24*60;    % scaling factor [day] -> [min]
expdata.SF.conc_to_nM  = 1;        % scaling factor [nM] -> [nM]


%%% -----------------------------------------------------------------------
%%% Experimental data
%%%

errorbar.available = {};
expdata.t.pla   = [8.57E-02 5.14E-01 1.03E+00 7.03E+00 1.41E+01 2.30E+01 3.00E+01 5.99E+01]';
expdata.C.pla   = [1.00E+03; 5.97E+02; 4.69E+02; 2.90E+02; 2.32E+02; 1.57E+02; 1.14E+02; 3.91E+01];
expdata.color.pla       = 'r--.';
expdata.limits.t.pla    = [0 60];

expdata.t.lun   = [7.33E-02 4.99E-01 9.83E-01 2.00E+00 3.99E+00 6.98E+00 9.99E+00]';
expdata.C.lun   = [1.16E+02; 1.00E+02; 8.78E+01; 6.53E+01; 5.63E+01; 5.15E+01; 4.06E+01];
expdata.color.lun       = 'k--.';
expdata.limits.t.lun    = [0 60];

expdata.t.hea   = [4.40E-02 4.98E-01 9.96E-01 1.99E+00 3.99E+00 6.99E+00 9.98E+00]';
expdata.C.hea   = [1.10E+02; 8.04E+01; 7.24E+01; 5.62E+01; 5.13E+01; 3.42E+01; 3.03E+01];
expdata.color.hea       = 'k--.';
expdata.limits.t.hea    = [0 60];

expdata.t.kid   = [5.87E-02 1.03E-01 2.79E-01 5.13E-01 1.01E+00 2.01E+00 4.00E+00 7.01E+00 1.00E+01]';
expdata.C.kid   = [1.61E+02; 1.23E+02; 1.14E+02; 1.03E+02; 7.11E+01; 5.05E+01; 3.59E+01; 3.48E+01; 3.28E+01];
expdata.color.kid       = 'k--.';
expdata.limits.t.kid    = [0 60];

expdata.t.mus   = [4.40E-02 2.64E-01 4.99E-01 9.98E-01 2.01E+00 3.99E+00 7.00E+00 1.00E+01]';
expdata.C.mus   = [1.13E+01; 1.23E+01; 1.29E+01; 1.58E+01; 1.73E+01; 1.35E+01; 1.33E+01; 1.01E+01];
expdata.color.mus       = 'b--.';
expdata.limits.t.mus    = [0 60];

expdata.t.ski   = [4.40E-02 5.13E-01 9.96E-01 1.99E+00 3.99E+00 6.99E+00 9.99E+00]';
expdata.C.ski   = [2.12E+01; 2.72E+01; 5.90E+01; 6.44E+01; 5.06E+01; 3.75E+01; 3.46E+01];
expdata.color.ski       = 'b--.';
expdata.limits.t.ski    = [0 60];

expdata.t.gut   = [4.40E-02 2.49E-01 4.98E-01 9.96E-01 2.01E+00 4.01E+00 6.99E+00 9.99E+00]';
expdata.C.gut   = [5.78E+01; 6.33E+01; 3.82E+01; 2.92E+01; 1.74E+01; 1.53E+01; 1.49E+01; 1.13E+01];
expdata.color.gut       = 'm--.';
expdata.limits.t.gut    = [0 60];

expdata.t.spl   = [6.97E-02 2.75E-01 5.23E-01 1.01E+00 2.02E+00 4.01E+00 7.00E+00 1.00E+01]';
expdata.C.spl   = [1.08E+02; 9.04E+01; 8.27E+01; 6.62E+01; 5.23E+01; 3.67E+01; 3.32E+01; 3.09E+01];
expdata.color.spl       = 'k--.';
expdata.limits.t.spl    = [0 60];

expdata.t.liv   = [4.40E-02 8.80E-02 2.64E-01 4.99E-01 9.83E-01 2.00E+00 3.99E+00 7.00E+00 9.99E+00]';
expdata.C.liv   = [1.40E+02; 1.19E+02; 1.38E+02; 7.86E+01; 6.87E+01; 5.03E+01; 4.52E+01; 3.82E+01; 3.23E+01];
expdata.color.liv       = 'k--.';
expdata.limits.t.liv    = [0 60];


expdata.errorbar = errorbar;

end
