%%% Version: October 31st, 2014
%%% 
%%% This function allows to compile some descriptive statistics realted to
%%% the virtual population
%%% 
%%% For references and citation, please see MAIN script.
%%% 
%%% Copyright (C) 2014, Universitaet Potsdam, Germany
%%% Contact: W. Huisinga, huisinga@uni-potsdam.de
%%%
%%% The program is distributed under the terms of the 
%%% Creative Commons License (CC BY-NC-SA 3.0):
%%% Attribution-NonCommercial-ShareAlike 3.0 Unported 
%%%
%%% For a SHORT HUMAN-READABLE SUMMARY OF THE LEGAL CODE, see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/
%%%
%%% For the Legal Code (the full license) see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/legalcode
%%%
%%%

function stats = GenericPBPKmodel_dataAnalysis(individual)


stats.size = length(individual); 

for id=1:stats.size 

    species = individual(id).species;
    stats.BH(id)      = species.BH;
    stats.BW(id)      = species.BW;
    stats.LBW(id)     = species.LBW; 
    stats.BMI(id)     = species.BMI; 
    stats.BSA(id)     = species.BSA; 
    stats.hct(id)     = species.hct; 
    stats.co(id)      = species.co; 

end;
