%%% Version: December 8th, 2014
%%%
%%% Experimental data
%%%
%%% Species: mouse, 25g, wild-type,  C57BL/6J strain

%%% Drug:    mAb7E3, murine IgG1, anti-platelet mAb with a
%%%          high affinity for the human glycoprotein IIb/IIIa,
%%%          does not bind to the murine glycoprotein IIb/IIIa

%%% Study:   125I-labeled 7E3 8 mg/kg BW, i.v. single bolus dosing,mouse were dosed with
%%%          IVIG 1g/kg before

%%% Units:   time in [day], concentration in [nmol/L]

%%% Source:  digitized graphics from Garg, PhD thesis (2007) Chapter 3,Fig.3

function expdata = ExperimentalData_mouse_wt_mAb7E3_IVIG1_Garg2007


%%% -----------------------------------------------------------------------
%%% Species
%%%

expdata.species.type   = 'mouse';
expdata.species.BW     = 0.025;   % in [kg]
expdata.species.FcRn_status = 'wild-type';


%%% -----------------------------------------------------------------------
%%% dosing information
%%%

dosing.drug      = 'mAb7E3';
dosing.route     = 'iv_bolus';
dosing.dose      = 8;
dosing.doseUnit  = 'mg/kg BW';
dosing.time      = 0;
dosing.timeUnit  = 'd';
dosing.repeats   = 1;
dosing.Tinf      = NaN;           % duration of iv infusion
dosing.interval  = NaN;           % multiple dosing interval

expdata.dosing   = dosing;


%%% -----------------------------------------------------------------------
%%% time information
%%%

pred.timeSpan = [0 60*24*60];
pred.timeUnit = 'd';

expdata.pred  = pred;


%%% -----------------------------------------------------------------------
%%% units and scaling factors
%%%
expdata.unit.t = 'day';
expdata.unit.C = 'nM';

expdata.SF.time_to_min = 24*60;    % scaling factor [day] -> [min]
expdata.SF.conc_to_nM  = 1;        % scaling factor [nM] -> [nM]


%%% -----------------------------------------------------------------------
%%% Experimental data
%%%
errorbar.available = {};
[A,b]=xlsread('Garg_7E3_Dose8_IVIG1g:kg_WT_plasma.xlsx');

index.pla=find(~isnan(A(:,ismember(b,'t.pla [days]'))));
expdata.t.pla   = [A(index.pla,ismember(b,'t.pla [days]'))'];
expdata.C.pla   = [A(index.pla,ismember(b,'C.pla [nM]'))'];
expdata.color.pla       = 'r--.';
expdata.limits.t.pla    = [0 60];



[A1,b1]=xlsread('Garg_7E3_Dose8_IVIG1g:kg_WT_lung.xlsx');
index.lun=find(~isnan(A1(:,ismember(b1,'t.lun [days]'))));
expdata.t.lun   = [A1(index.lun,ismember(b1,'t.lun [days]'))'];
expdata.C.lun   = [A1(index.lun,ismember(b1,'C.lun [nM]'))'];
expdata.color.lun       = 'k--.';
expdata.limits.t.lun    = [0 14];

[A2,b2]=xlsread('Garg_7E3_Dose8_IVIG1g:kg_WT_GIT.xlsx');
index.gut=find(~isnan(A2(:,ismember(b2,'t.git [days]'))));
expdata.t.gut   = [A2(index.gut,ismember(b2,'t.git [days]'))'];
expdata.C.gut   = [A2(index.gut,ismember(b2,'C.git [nM]'))'];
expdata.color.gut       = 'k--.';
expdata.limits.t.gut    = [0 14];

[A3,b3]=xlsread('Garg_7E3_Dose8_IVIG1g:kg_WT_liver.xlsx');
index.liv=find(~isnan(A3(:,ismember(b3,'t.liv [days]'))));
expdata.t.liv   = [A3(index.liv,ismember(b3,'t.liv [days]'))'];
expdata.C.liv   = [A3(index.liv,ismember(b3,'C.liv [nM]'))'];
expdata.color.liv       = 'k--.';
expdata.limits.t.liv    = [0 14];

[A4,b4]=xlsread('Garg_7E3_Dose8_IVIG1g:kg_WT_spleen.xlsx');
index.spl=find(~isnan(A4(:,ismember(b4,'t.spl [days]'))));
expdata.t.spl   = [A4(index.spl,ismember(b4,'t.spl [days]'))'];
expdata.C.spl   = [A4(index.spl,ismember(b4,'C.spl [nM]'))'];
expdata.color.spl       = 'k--.';
expdata.limits.t.spl    = [0 14];

[A5,b5]=xlsread('Garg_7E3_Dose8_IVIG1g:kg_WT_heart.xlsx');
index.hea=find(~isnan(A5(:,ismember(b5,'t.hea [days]'))));
expdata.t.hea   = [A5(index.hea,ismember(b5,'t.hea [days]'))'];
expdata.C.hea   = [A5(index.hea,ismember(b5,'C.hea [nM]'))'];
expdata.color.hea       = 'k--.';
expdata.limits.t.hea    = [0 14];

[A6,b6]=xlsread('Garg_7E3_Dose8_IVIG1g:kg_WT_kidney.xlsx');
index.kid=find(~isnan(A6(:,ismember(b6,'t.kid [days]'))));
expdata.t.kid   = [A6(index.kid,ismember(b6,'t.kid [days]'))'];
expdata.C.kid   = [A6(index.kid,ismember(b6,'C.kid [nM]'))'];
expdata.color.kid       = 'k--.';
expdata.limits.t.kid    = [0 14];


[A7,b7]=xlsread('Garg_7E3_Dose8_IVIG1g:kg_WT_skin.xlsx');
index.ski=find(~isnan(A7(:,ismember(b7,'t.ski [days]'))));
expdata.t.ski   = [A7(index.ski,ismember(b7,'t.ski [days]'))'];
expdata.C.ski   = [A7(index.ski,ismember(b7,'C.ski [nM]'))'];
expdata.color.ski       = 'k--.';
expdata.limits.t.ski    = [0 14];


[A8,b8]=xlsread('Garg_7E3_Dose8_IVIG1g:kg_WT_muscle.xlsx');
index.mus=find(~isnan(A8(:,ismember(b8,'t.mus [days]'))));
expdata.t.mus   = [A8(index.mus,ismember(b8,'t.mus [days]'))'];
expdata.C.mus   = [A8(index.mus,ismember(b8,'C.mus [nM]'))'];
expdata.color.mus       = 'k--.';
expdata.limits.t.mus    = [0 14];
expdata.errorbar = errorbar;



end
