% precomputation
%
% script performing precomputations of variables that are needed in each
% time step such as the action of the generator A on the basis functions
%
% written by
%   Andrea Y. Weisse
%   Centre for Systems Biology at Edinburgh
%   University of Edinburgh
%
%   email: andrea.weisse@ed.ac.uk
%
% Copyright (C) 2011, University of Edinburgh
%
% FOR ACADEMIC USE this program is free software; you can redistribute 
% it and/or modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version. 
% See http://www.gnu.org/licenses/gpl.html for details.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details. 
% 


% find out which grid points to consider for evaluation of each GPP
adjM    = adjacencyMatrix(basis, basis.mu, D, h, delta);

%% precomputation of densities at grid points
zGz     = inf * ones(basis.no, basis.no);
switch basis.function
    case 'gaussian'
        for m = 1:basis.no
            adj         = adjM(m,:);
            Nadj        = sum(adj);
            zGz(adj,m)  = scalarProd(basis.mu(:,adj)-basis.mu(:,m)*ones(1,Nadj),basis.G,basis.mu(:,adj)-basis.mu(:,m)*ones(1,Nadj))';
        end
        dens_zGz = exp(-.5 * zGz + basis.a);
    case 'laguerre4'
        for m = 1:basis.no
            zGz(:,m)  = scalarProd(basis.mu-basis.mu(:,m) * ones(1,basis.no), basis.G, basis.mu-basis.mu(:,m) * ones(1,basis.no));%sum((chol(basis.G) * abs(basis.mu-basis.mu(:,m)*ones(1,basis.no))).^2, 1);
        end           
        dens_zGz = ((model.dim + 2)/2 - zGz) .* exp(-zGz + basis.a);
    case 'laguerre6'
        for m = 1:basis.no
            zGz(:,m)  = scalarProd(basis.mu-basis.mu(:,m) * ones(1,basis.no), basis.G, basis.mu-basis.mu(:,m) * ones(1,basis.no));%sum((chol(basis.G) * abs(basis.mu-basis.mu(:,m)*ones(1,basis.no))).^2, 1);
        end           
        dens_zGz = ((2+model.dim/2)*(1+model.dim/2)/2 - (2+model.dim/2)*zGz + (zGz.^2)/2) .* exp(-zGz + basis.a);
end

if model.dim > 1
    xGx     = inf * ones(length(x), length(x));
    yGy     = inf * ones(length(y), length(y));
    switch basis.function
        case 'gaussian'
            for m = 1:length(x)
                xGx(:,m)    = (x - x(m)).^2 * basis.G(fig.ind(1), fig.ind(1));
            end
            for m = 1:length(y)
                yGy(:,m)    = (y - y(m)).^2 * basis.G(fig.ind(2), fig.ind(2));
            end
            dens_xGx = exp(-.5 * xGx - log(sqrt(2*pi*basis.S(fig.ind(1), fig.ind(1)))));
            dens_yGy = exp(-.5 * yGy - log(sqrt(2*pi*basis.S(fig.ind(2), fig.ind(2)))));
        case 'laguerre4'
            for m = 1:length(x)
                xGx(:,m)    = (x - x(m)).^2 * basis.G(fig.ind(1), fig.ind(1));
            end
            for m = 1:length(y)
                yGy(:,m)    = (y - y(m)).^2 * basis.G(fig.ind(2), fig.ind(2));
            end
            dens_xGx = (3/2 - xGx) .* exp(-xGx - log(sqrt(pi*basis.S(fig.ind(1), fig.ind(1)))));
            dens_yGy = (3/2 - yGy) .* exp(-yGy - log(sqrt(pi*basis.S(fig.ind(2), fig.ind(2)))));
        case 'laguerre6'
            for m = 1:length(x)
                xGx(:,m)    = (x - x(m)).^2 * basis.G(fig.ind(1), fig.ind(1));
            end
            for m = 1:length(y)
                yGy(:,m)    = (y - y(m)).^2 * basis.G(fig.ind(2), fig.ind(2));
            end
            dens_xGx = (15/8 - 5/2 * xGx + (xGx.^2)/2) .* exp(-xGx - log(sqrt(pi*basis.S(fig.ind(1), fig.ind(1)))));
            dens_yGy = (15/8 - 5/2 * yGy + (yGy.^2)/2) .* exp(-yGy - log(sqrt(pi*basis.S(fig.ind(2), fig.ind(2)))));
    end
end

%% precomputation of A*u
Fz       = feval(model.F,t,basis.mu,model.par);
FzGz_mu  = zeros(basis.no, basis.no);
for m = 1:basis.no
    z_mu         = basis.mu - basis.mu(:,m)*ones(1,basis.no);
    FzGz_mu(m,:) = scalarProd(Fz,basis.G,z_mu);
end;
switch basis.function
    case 'laguerre6'
        if model.dim == 1 || length(h) == 1
            Au      = ctauA(model,t,1,1,basis,basis.mu,dens_zGz',FzGz_mu,zGz) * h^model.dim;
        else
            Au      = ctauA(model,t,1,1,basis,basis.mu,dens_zGz',FzGz_mu,zGz) * prod(h);
        end

    otherwise
        if model.dim == 1 || length(h) == 1
            Au      = ctauA(model,t,1,1,basis,basis.mu,dens_zGz',FzGz_mu) * h^model.dim;
        else
            Au      = ctauA(model,t,1,1,basis,basis.mu,dens_zGz',FzGz_mu) * prod(h);
        end
end
%% sort out points at border of domain for the error estimation!
if model.dim == 1
    bla.mu      = min(basis.mu);
    bla.no      = 1;
    errCut      = sum(adjacencyMatrix(bla, basis.mu, D, h, delta))+1;
    pts4est     = true(1,basis.no);
    pts4est([(1:errCut-1), (basis.no-errCut+2:basis.no)]) = false;
    clear errCut bla;
elseif model.dim == 2
    % pts at border:
    minX = min(basis.mu(1,:)); minY = min(basis.mu(2,:));
    maxX = max(basis.mu(1,:)); maxY = max(basis.mu(2,:));
    border = (basis.mu(1,:)==minX | basis.mu(1,:)==maxX | ...
        basis.mu(2,:)==minY | basis.mu(2,:)==maxY);
    % now find pts adjacent to border pts:
    bla.mu = basis.mu(:,border); bla.no = sum(border);
    adjM = adjacencyMatrix(bla, basis.mu, D, h, delta);
    pts4est = false(1,basis.no);
    for m = 1:bla.no
        pts4est = pts4est | adjM(m,:);
    end
    % now take only pts not adjacent to border pts:
    pts4est = ~pts4est;
    clear adjM bla;
else
    error('Sorry! Sorting out points at border of domain not implemented yet for dim > 2.');
end