function dZ = hill2d_F(t,Z,k)
% function HILL2D_F
%
% hill kinetics in 2 space dimension (the 1d state space is extended by the
% parameter V)
% 
% input
%     t       time 
%     Z       1xn vector containing the points at which to evaluate the 
%             hill kinetics
%     k       1x2 vector containing the parameters K and c
% 
% output
%     dZ      2xn vector containing the RHS evaluated at Z

% number of points
n = size(Z,2);

% space variables x and V
x = Z(1,:);
V = Z(2,:);

% parameters
K = k(1); c = k(2);

% hill kinetics
dx = -V.*x.^c ./ (K^c + x.^c);
% V doesn't change in time
dV = zeros(size(V));

dZ = [dx; dV];