function trace = hill1d_traceDF(t,Z,k)
% function HILL1D_traceDF
%
% trace of Jacobian of RHS
% (in 1 space dimension this is equivalent to the derivative of the RHS)
% 
% input
%     t       time 
%     Z       1xn vector containing the points at which to evaluate the 
%             hill kinetics
%     k       1x3 vector containing the parameters V, K and c
% 
% output
%     trace   1xn vector containing the derivatives of the hill kinetics 
%             evaluated at Z

% number of points
n = size(Z,2);

% parameters
V = k(1); K = k(2); c = k(3);

trace  = V * c * Z.^(c-1) * K^c ./ (K^c + Z.^c).^2;