function dZ = hill1d_F(t,Z,k)
% function HILL1D_F
%
% hill kinetics in 1 dimension
% 
% input
%     t       time 
%     Z       1xn vector containing the points at which to evaluate the 
%             hill kinetics
%     k       1x3 vector containing the parameters V, K and c
% 
% output
%     dZ      1xn vector containing the hill kinetics evaluated at Z

% number of points
n = size(Z,2);

% parameters
V = k(1); K = k(2); c = k(3);

% hill kinetics
dZ = V*Z.^c ./ (K^c + Z.^c);