%%% Version: August 28th, 2017
%%%
%%% [I]  =  Wajima_bloodCoagulation_indexing
%%%
%%% This function defines the indexing for the state variables and parameter vector of 
%%% the blood coagulation model 
%%%
%%% Input: none
%%%
%%% Output: I      - indexing for state variables and parameter vector
%%%
%%% Authors: Jane Knoechel & Wilhelm Huisinga
%%%

function I  =  Wajima_bloodCoagulation_indexing
%%% ----------------------------------------------------------------------
%%% model states
%%%
states = {'XII','XIIa','VIII','VIIIa','IX','IXa','XI','XIa','VII','VIIa','X',...
    'Xa','V','Va','Xa_Va','II','Xa_TFPI', 'VIIa_TF_Xa_TFPI',...
    'IIa','TAT','Fg','F','XF','FDP','D','XIII','XIIIa','Pg','P',...
    'PC','APC','Tmod','IIa_Tmod','IXa_VIIIa','TF','VII_TF','VIIa_TF','TFPI',...
    'VK','VKH2','VKO','VK_p','PS','APC_PS','Pk','K','CA','AVenom','CVenom',...
    'AT_III_Heparin','AEnox','Awarf','Cwarf','ENO_p','AUC','TaipanVenom','ATIII',...
    'delayTaipan1','delayTaipan2','AVenom_Tiger','CVenom_Tiger','AT_III_UFH'};

I.nrOfStates = length(states);
I.allStates = 1:I.nrOfStates;
I.stateName = states;

%%% create indexing
for i = I.allStates
    I.(states{i})=i;
end
%%% ----------------------------------------------------------------------
%%% model parameters
%%%
par = {'v1','k1',...
    'v2','k2',...
    'v3','k3',...
    'v4','k4',...
    'v5','k5',...
    'v6','k6',...
    'v7','k7',...
    'v8','k8',...
    'v9','k9',...
    'v10','k10',...
    'v11','k11',...
    'v12','k12',...
    'v13','k13',...
    'v14','k14',...
    'v15','k15',...
    'v16','k16',...
    'v17','k17',...
    'v18','k18',...
    'v19','k19',...
    'v20','k20',...
    'v21','k21',...
    'v22','k22',...
    'v23','k23',...
    'v24','k24',...
    'v25','k25',...
    'c26','c27','c28','c29','c30','c31','c32',...
    'v33','k33',...
    'v34','k34',...
    'v35','k35',...
    'v36','k36',...
    'c37',...
    'v38','k38',...
    'v39','k39',...
    'v40','k40',...
    'v41','k41',...
    'v42','k42',...
    'v43','k43',...
    'R1','c44','c45','R2','c46','lmax','IC50',...
    'aII','aVII','aIX','aX','aPC','aPS','pV','pVIII','pFg',...
    'pXIII','pPg','pTmod','pXI','pTFPI','pVK','pXII','pPk',...
    'degFg','degF','degXF','degII','degIIa','degTF','degV','degVa','degVII','degVIIa','degVIII',...
    'degVIIIa','degIX','degIXa','degX','degXa','degXI','degXIa','degXII','degXIIa',...
    'degXIII','degXIIIa','degPk','degK','degPg','degP','degPC','degAPC','degPS',...
    'degFDP','degD','degTFPI','degVIIaTF','degVIITF','degAPCPS','degXaVa',...
    'degIXaVIIIa','degTmod','degIIaTmod','degXaTFPI','degVIIaTFXaTFPI',...
    'degTAT','degCA','degVK','degVK2','degVKH2','degVKO','ka_Brown','d_Brown',...
    'ka_Warf','Vd_Warf','Cl_Warf','ke_Warf','ka_Hep','Vc_Hep',...
    'Vp_Hep','Cl_Hep','Q_Hep','ke_Hep','k12_Hep','k21_Hep','VK_k12','VK_k21','VK_V',...
    'd_Taipan','ktrans_Taipan','ka_Tiger','d_Tiger','inf_rate_UFH','vtaipan','ktaipan'};

I.nrOfPar   = length(par);
I.allPar    = 1:I.nrOfPar;
I.parName   = par;

%%% create indexing
for i = I.allPar
    I.(par{i})=i;
end

end

